/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.math.BigDecimal;
import java.util.ArrayList;

public class Trace {
    private DynamicList<ConcreteState> concreteStates;
    private DynamicList<SymbolicState> symbolicStates;
    private DynamicList<SystemEdgeSelect[]> transitionsEdges;
    private DynamicList<BigDecimal> entryTimes;

    public Trace(SymbolicState initialSymbolicState) {
        this.reset(null, initialSymbolicState);
    }

    public Trace(ConcreteState initialConcreteState) {
        this.reset(initialConcreteState, null);
    }

    public Trace(ConcreteState initialConcreteState, SymbolicState initialSymbolicState) {
        this.reset(initialConcreteState, initialSymbolicState);
    }

    public void reset(ConcreteState initialConcreteState, SymbolicState initialSymbolicState) {
        if (initialConcreteState != null) {
            this.concreteStates = new DynamicList();
            this.concreteStates.add(initialConcreteState);
            this.entryTimes = new DynamicList();
            this.entryTimes.add(BigDecimal.ZERO);
        } else {
            this.concreteStates = null;
            this.entryTimes = null;
        }
        if (initialSymbolicState != null) {
            this.symbolicStates = new DynamicList();
            this.symbolicStates.add(initialSymbolicState);
        } else {
            this.symbolicStates = null;
        }
        this.transitionsEdges = new DynamicList();
    }

    public void clearAfterState(int i) {
        if (this.concreteStates != null) {
            this.concreteStates.removeRange(i + 1, this.concreteStates.size());
            this.entryTimes.removeRange(i + 1, this.entryTimes.size());
        }
        if (this.symbolicStates != null) {
            this.symbolicStates.removeRange(i + 1, this.symbolicStates.size());
        }
        this.transitionsEdges.removeRange(i, this.transitionsEdges.size());
    }

    public void append(BigDecimal delay, SystemEdgeSelect[] transitionEdges, ConcreteState concreteState, SymbolicState symbolicState) {
        if (this.concreteStates != null) {
            int size = this.entryTimes.size();
            if (size == 0) {
                this.entryTimes.add(delay);
            } else {
                this.entryTimes.add(((BigDecimal)this.entryTimes.get(size - 1)).add(delay));
            }
            this.concreteStates.add(concreteState);
        }
        if (this.symbolicStates != null) {
            this.symbolicStates.add(symbolicState);
        }
        this.transitionsEdges.add(transitionEdges);
    }

    public void append(BigDecimal delay, SystemEdgeSelect[] transitionEdges, ConcreteState concreteState) {
        this.append(delay, transitionEdges, concreteState, null);
    }

    public void append(SystemEdgeSelect[] transitionEdges, SymbolicState symbolicState) {
        this.append(null, transitionEdges, null, symbolicState);
    }

    public BigDecimal getEntryTime(int i) {
        if (this.entryTimes == null) {
            throw new IllegalStateException();
        }
        return (BigDecimal)this.entryTimes.get(i);
    }

    public BigDecimal getDelay(int i) {
        if (this.entryTimes == null) {
            throw new IllegalStateException();
        }
        if (i + 1 < this.entryTimes.size()) {
            return ((BigDecimal)this.entryTimes.get(i + 1)).subtract((BigDecimal)this.entryTimes.get(i));
        }
        return null;
    }

    public SystemEdgeSelect[] getTransitionEdges(int i) {
        return (SystemEdgeSelect[])this.transitionsEdges.get(i);
    }

    public SymbolicTransition getSymbolicTransition(int i) {
        if (this.symbolicStates == null) {
            throw new IllegalStateException();
        }
        if (i + 1 < this.symbolicStates.size()) {
            return new SymbolicTransition(this.getSymbolicState(i), this.getTransitionEdges(i), this.getSymbolicState(i + 1));
        }
        return null;
    }

    public ConcreteState getConcreteState(int i) {
        if (this.concreteStates == null) {
            throw new IllegalStateException();
        }
        return (ConcreteState)this.concreteStates.get(i);
    }

    public SymbolicState getSymbolicState(int i) {
        if (this.symbolicStates == null) {
            throw new IllegalStateException();
        }
        return (SymbolicState)this.symbolicStates.get(i);
    }

    public int size() {
        return this.transitionsEdges.size() + 1;
    }

    private class DynamicList<E>
    extends ArrayList<E> {
        private DynamicList() {
        }

        @Override
        public void removeRange(int from, int to) {
            super.removeRange(from, to);
            this.trimToSize();
        }
    }
}

