/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.GanttAddition;
import com.uppaal.model.system.GanttBar;
import com.uppaal.model.system.GanttRow;
import com.uppaal.model.system.concrete.Limit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttChart
implements Cloneable {
    private final List<GanttRow> rows = new ArrayList<GanttRow>();

    public void addRow(GanttRow row) {
        this.rows.add(row);
    }

    public int noOfRows() {
        return this.rows.size();
    }

    public GanttRow getRow(int i) {
        return this.rows.get(i);
    }

    public void truncate(double t) {
        for (GanttRow r : this.rows) {
            r.truncate(t);
        }
    }

    public void clearChart() {
        Iterator<GanttRow> i = this.rows.iterator();
        while (i.hasNext()) {
            i.next().clearRow();
        }
    }

    public Limit maximalNonInfiniteEndTime() {
        Limit tmp = new Limit(0.0, true);
        boolean flagInfinite = true;
        for (GanttRow r : this.rows) {
            Limit rowEndTime = r.maximalNonInfiniteEndTime();
            if (rowEndTime.isUnbounded() || !rowEndTime.isUpperBoundOf(tmp.getValue())) continue;
            tmp = rowEndTime;
            flagInfinite = false;
        }
        if (flagInfinite) {
            tmp.setValue(Double.POSITIVE_INFINITY);
        }
        return tmp;
    }

    public void printGanttInfo() {
        System.out.println();
        System.out.println("Gantt bar dump");
        System.out.println("Number of rows: " + this.rows.size());
        System.out.println();
        for (int i = 0; i < this.rows.size(); ++i) {
            System.out.print("Row: " + i + " ");
            this.rows.get(i).printRowInfo();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GanttChart theClone = new GanttChart();
        for (GanttRow row : this.rows) {
            theClone.rows.add((GanttRow)row.clone());
        }
        return theClone;
    }

    public void add(double globalTime, List<GanttAddition> additions) {
        this.truncate(globalTime);
        for (GanttAddition addition : additions) {
            GanttRow row = this.getRow(addition.getRowId());
            GanttBar bar = new GanttBar(globalTime, addition.getValue());
            row.addBar(bar);
        }
    }
}

