/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class QueryListStreamWriter {
    private final OutputStream os;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public QueryListStreamWriter(OutputStream os) {
        this.os = os;
    }

    public void write(QueryList queryList, String version) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(this.os, StandardCharsets.ISO_8859_1);
        osw.write("//This file was generated from " + version + "\n");
        for (Query query : queryList) {
            String comment = query.getComment();
            comment = comment.replaceAll("\\\\", "\\\\\\\\");
            comment = comment.replaceAll("/", "\\\\/");
            osw.write("\n/*\n" + QueryListStreamWriter.encode(comment) + "\n*/\n");
            String formula = query.getFormula();
            formula = formula.trim().equals("") ? "//NO_QUERY" : formula.replaceAll("(?m)\\n", "\\\\\n");
            osw.write(formula + "\n");
        }
        osw.flush();
    }

    private static void byteToHex(StringBuffer buf, byte b) {
        buf.append(hexDigit[b >> 4 & 0xF]).append(hexDigit[b & 0xF]);
    }

    private static String encode(String s) {
        StringBuffer buf = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ((c & 0xFFFFFF80) == 0) {
                buf.append(c);
                continue;
            }
            byte hi = (byte)(c >>> 8);
            byte lo = (byte)(c & 0xFF);
            buf.append("\\u");
            QueryListStreamWriter.byteToHex(buf, hi);
            QueryListStreamWriter.byteToHex(buf, lo);
        }
        return buf.toString();
    }
}

