/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.PlotConfiguration;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.io2.XMLWriter;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class FullXMLWriter
extends XMLWriter {
    public FullXMLWriter(OutputStream stream) throws XMLStreamException {
        super(stream);
    }

    @Override
    public void visitQueries(QueryList queries) throws Exception {
        this.indent();
        this.writer.writeStartElement("queries");
        ++this.depth;
        this.visitSettings(queries.getDocument().getSettings());
        super.visitQueries(queries);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitConcretePlotConfigs(List<PlotConfiguration> plots) throws Exception {
        if (plots == null || plots.isEmpty()) {
            return;
        }
        this.indent();
        this.writer.writeStartElement("simulator");
        this.writer.writeAttribute("type", "concrete");
        ++this.depth;
        for (PlotConfiguration plot : plots) {
            this.indent();
            this.writer.writeStartElement("plot-widget");
            this.writer.writeAttribute("title", plot.title);
            ++this.depth;
            for (String variable : plot.variables) {
                this.indent();
                this.writer.writeStartElement("expression");
                this.writer.writeCharacters(variable);
                this.writer.writeEndElement();
            }
            --this.depth;
            this.indent();
            this.writer.writeEndElement();
        }
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }
}

