/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2.lsc;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscElement;
import java.util.ArrayList;

public class Message
extends LscElement {
    protected InstanceLine source;
    protected InstanceLine target;

    public Message(Element prototype) {
        super(prototype);
    }

    public InstanceLine getSource() {
        return this.source;
    }

    public InstanceLine getTarget() {
        return this.target;
    }

    public void setSource(InstanceLine source) {
        InstanceLine old = this.source;
        this.source = source;
        this.fireSourceChanged(old);
    }

    void fireSourceChanged(InstanceLine oldSource) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.messageSourceChanged(this, oldSource, this.source);
                }
            } while ((element = element.prototype) != null);
        }
    }

    public void setTarget(InstanceLine target) {
        InstanceLine old = this.target;
        this.target = target;
        this.fireTargetChanged(old);
    }

    void fireTargetChanged(InstanceLine oldTarget) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.messageTargetChanged(this, oldTarget, this.target);
                }
            } while ((element = element.prototype) != null);
        }
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitMessage(this);
    }

    @Override
    public ArrayList<InstanceLine> getAnchors() {
        ArrayList<InstanceLine> array = new ArrayList<InstanceLine>();
        array.add(this.getSource());
        if (this.getSource() != this.getTarget()) {
            array.add(this.getTarget());
        }
        return array;
    }

    @Override
    public Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#message");
    }

    @Override
    public String getFriendlyName() {
        return "message";
    }

    @Override
    public String getLabelValue() {
        return (String)this.getPropertyValue("message");
    }
}

