/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.engine.Option;
import com.uppaal.model.core2.EngineSettings;
import java.util.HashMap;
import java.util.Map;

public class SettingsChangeTransaction {
    private EngineSettings settings;
    Map<String, Update> updates = new HashMap<String, Update>();

    public SettingsChangeTransaction(EngineSettings settings) {
        this.settings = settings;
    }

    public <T> void setValue(Option<T> option, T value) {
        String oldValue = this.settings.getValue(option.getName());
        String newValue = value == null || option.getDefaultValue().equals(value) ? null : value.toString();
        this.updates.put(option.getName(), new Update(oldValue, newValue));
    }

    public boolean willBeDefaultValue(Option<?> option) {
        Update update = this.updates.get(option.getName());
        if (update != null) {
            return update.newValue == null;
        }
        return this.settings.isPropertyLocal(option.getName());
    }

    public void execute() {
        for (Map.Entry<String, Update> entry : this.updates.entrySet()) {
            this.settings.setValue(entry.getKey(), entry.getValue().newValue);
        }
    }

    private class Update {
        public final String oldValue;
        public final String newValue;

        public Update(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

