/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.SetPropertyCommand;
import java.util.ArrayList;

public class SetInitialLocationCommand
extends AbstractCommand {
    protected SetPropertyCommand newLocationProperty;
    protected SetPropertyCommand oldLocationProperty;

    public SetInitialLocationCommand(Element location, boolean isInitial) {
        this.newLocationProperty = new SetPropertyCommand(location, "init", isInitial);
        Location oldInitialLocation = this.getInitialLocation(location.getTemplate());
        if (oldInitialLocation != null && oldInitialLocation != location) {
            this.oldLocationProperty = new SetPropertyCommand(oldInitialLocation, "init", !isInitial);
        }
    }

    private Location getInitialLocation(AbstractTemplate template) {
        ArrayList<Location> oldInitialLocations = this.findInitialLocations(template);
        if (oldInitialLocations.size() == 1) {
            return oldInitialLocations.get(0);
        }
        for (Location location : oldInitialLocations) {
            location.setProperty("init", null);
        }
        return null;
    }

    private ArrayList<Location> findInitialLocations(AbstractTemplate template) {
        final ArrayList<Location> oldInitialLocations = new ArrayList<Location>();
        if (template != null) {
            template.acceptSafe(new AbstractVisitor(){

                @Override
                public void visitLocation(Location location) {
                    if (((Boolean)location.getPropertyValue("init")).booleanValue()) {
                        oldInitialLocations.add(location);
                    }
                }
            });
        }
        return oldInitialLocations;
    }

    @Override
    public void execute() {
        this.newLocationProperty.execute();
        if (this.oldLocationProperty != null) {
            this.oldLocationProperty.execute();
        }
    }

    @Override
    public void undo() {
        this.newLocationProperty.undo();
        if (this.oldLocationProperty != null) {
            this.oldLocationProperty.undo();
        }
    }

    @Override
    public Element getModifiedElement() {
        return this.newLocationProperty.getModifiedElement();
    }
}

