/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

public class QueryValue {
    private Status status;
    private Kind kind;
    private String value;

    public QueryValue(String status, String kind, String value) {
        this.setStatus(status);
        this.setKind(kind);
        this.value = value;
    }

    public QueryValue(Status status, Kind kind, String value) {
        this.status = status;
        this.kind = kind;
        this.value = value;
    }

    public QueryValue() {
    }

    public void setStatus(String result) {
        switch (result) {
            case "success": {
                this.status = Status.Success;
                break;
            }
            case "maybe-true": {
                this.status = Status.Maybe_True;
                break;
            }
            case "maybe-false": {
                this.status = Status.Maybe_False;
                break;
            }
            case "failure": {
                this.status = Status.Failure;
                break;
            }
            default: {
                this.status = Status.Unchecked;
            }
        }
    }

    public void setStatus(char result) {
        switch (result) {
            case 'T': {
                this.status = Status.Success;
                break;
            }
            case 'M': {
                this.status = Status.Maybe_True;
                break;
            }
            case 'N': {
                this.status = Status.Maybe_False;
                break;
            }
            case 'F': {
                this.status = Status.Failure;
                break;
            }
            default: {
                this.status = Status.Unchecked;
            }
        }
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public char getStatusLabel() {
        switch (this.status) {
            case Success: {
                return 'T';
            }
            case Maybe_True: {
                return 'M';
            }
            case Maybe_False: {
                return 'N';
            }
            case Failure: {
                return 'F';
            }
            case Unchecked: {
                return 'E';
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.status);
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void setKind(String kind) {
        if (kind.equals("quality")) {
            this.setKind(Kind.Quality);
        } else if (kind.equals("quantity")) {
            this.setKind(Kind.Quantity);
        } else if (kind.matches("(confidence[ _-]?)?interval")) {
            this.setKind(Kind.Interval);
        } else {
            this.setKind(Kind.Unknown);
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static enum Kind {
        Quality,
        Quantity,
        Interval,
        Unknown;

    }

    public static enum Status {
        Success,
        Maybe_True,
        Maybe_False,
        Failure,
        Unchecked;

    }
}

