/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.engine.EngineOptions;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.EngineSettings;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.QueryExpected;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.core2.QueryResultListener;
import com.uppaal.model.core2.Visitor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Node {
    private static final String PROP_FORMULA = "formula";
    private static final String PROP_COMMENT = "comment";
    private final ArrayList<QueryResultListener> queryResultListeners = new ArrayList();

    public Query(String formula, String comment) {
        super(null);
        assert (formula != null && comment != null);
        this.setProperty(PROP_FORMULA, formula);
        this.setProperty(PROP_COMMENT, comment);
    }

    public Query(String formula) {
        this(formula, "");
    }

    public Query() {
        this("", "");
    }

    @Override
    public CommandManager getCommandManager() {
        return this.getParent().getCommandManager();
    }

    @Override
    public String getFriendlyName() {
        return "query";
    }

    public EngineSettings getSettings() {
        return (EngineSettings)this.getPropertyValue("settings");
    }

    public EngineSettings deriveSettings(EngineOptions options) {
        Document doc;
        EngineSettings docSettings;
        EngineSettings res = this.getSettings();
        res = res != null ? res.copy() : ((docSettings = (doc = this.getDocument()).getSettings()) != null ? docSettings.copy() : new EngineSettings(options.getDefaultSettings()));
        return res;
    }

    public void setSettings(EngineSettings settings) {
        this.setProperty("settings", settings);
    }

    public void clearSettings() {
        this.setProperty("settings", null);
    }

    public boolean hasPlots() {
        return this.getFirstInstance(QueryResult.class).map(res -> !res.getPlots().isEmpty()).orElse(false);
    }

    public void addQueryResultListener(QueryResultListener l) {
        this.queryResultListeners.add(l);
    }

    public void removeQueryResultListener(QueryResultListener l) {
        this.queryResultListeners.remove(l);
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Deprecated
    private void fireResultsChanged(QueryResult result) {
        Object[] ls;
        for (Object l : ls = this.queryResultListeners.toArray()) {
            ((QueryResultListener)l).resultsChanged(this, result);
        }
    }

    public String getFormula() {
        return Objects.requireNonNullElse((String)this.getPropertyValue(PROP_FORMULA), "");
    }

    public String getComment() {
        return Objects.requireNonNullElse((String)this.getPropertyValue(PROP_COMMENT), "");
    }

    public void setFormula(String formula) {
        assert (formula != null);
        this.setProperty(PROP_FORMULA, formula);
    }

    public void setComment(String comment) {
        assert (comment != null);
        this.setProperty(PROP_COMMENT, comment);
    }

    public Property getFormulaProperty() {
        return this.getProperty(PROP_FORMULA);
    }

    public Property getCommentProperty() {
        return this.getProperty(PROP_COMMENT);
    }

    public void setFormulaAndComment(String formula, String comment) {
        if (formula != null) {
            this.setProperty(PROP_FORMULA, formula);
        }
        if (comment != null) {
            this.setProperty(PROP_COMMENT, comment);
        }
    }

    public void setResult(QueryResult result) {
        Optional<QueryResult> old = this.getFirstInstance(QueryResult.class);
        if (old.isPresent()) {
            this.insert(result, old.get());
            old.get().remove();
        } else {
            this.insert(result, this.getLast());
        }
        this.fireResultsChanged(result);
    }

    public QueryResult getResult() {
        return this.getFirstInstance(QueryResult.class).orElse(new QueryResult());
    }

    public QueryExpected getExpected() {
        return this.getFirstInstance(QueryExpected.class).orElse(new QueryExpected());
    }

    public void setExpected(QueryExpected expect) {
        Optional<QueryExpected> old = this.getFirstInstance(QueryExpected.class);
        if (old.isPresent()) {
            this.insert(expect, old.get());
            old.get().remove();
        } else {
            this.insert(expect, this.getLast());
        }
    }

    public String getShortFormula() {
        String s = this.getFormula();
        StringBuilder out = new StringBuilder();
        boolean spacePrinted = false;
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (spacePrinted) {
                    last = i;
                    continue;
                }
                out.append(s, last, i - 1).append(' ');
                last = i;
                spacePrinted = true;
                continue;
            }
            spacePrinted = false;
        }
        out.append(s.substring(last));
        return new String(out);
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitQuery(this);
    }

    public String toString() {
        Object res = this.getShortFormula();
        if (((String)res).length() > 60) {
            res = ((String)res).substring(0, 60) + "\u2026";
        }
        return res;
    }
}

