/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.Message;
import java.awt.Color;
import java.awt.Font;
import java.util.Map;

public class Property
extends Element {
    protected Object value;

    public Property(Element parent, Element prototype, Object value) {
        super(prototype);
        this.parent = parent;
        this.value = value;
    }

    public void setValue(Object value) {
        this.setValue(value, this.getName());
    }

    void setValue(Object value, String ownName) {
        Object old = this.value;
        this.value = value;
        this.parent.firePropertyChanged(this, ownName, old, value);
    }

    public <T> T getValue() {
        Object res = this.value;
        return (T)res;
    }

    public Property setX(int x) {
        this.setProperty("x", x);
        return this;
    }

    public Property setY(int y) {
        this.setProperty("y", y);
        return this;
    }

    public Property setXY(int x, int y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    @Override
    public Color getColor() {
        return (Color)this.getPropertyValue("color");
    }

    public Font getFont() {
        return (Font)this.getPropertyValue("font");
    }

    public boolean isVisible() {
        return (Boolean)this.getPropertyValue("visible");
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitProperty(this);
    }

    public String getName() {
        for (Map.Entry<String, Property> entry : this.parent.getProperties().entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Element getPrototypeFromParent(Element parent) {
        if (parent.prototype == null) {
            return null;
        }
        return parent.prototype.getProperty(this.getName());
    }

    @Override
    public int getX() {
        if (this.getParent() instanceof Message) {
            Float f = (Float)this.getPropertyValue("f");
            if (f.floatValue() == 10.0f) {
                return super.getX();
            }
            Message message = (Message)this.getParent();
            int s = message.getSource() == null ? message.getX() : message.getSource().getX();
            int t = message.getTarget() == null ? message.getX() : message.getTarget().getX();
            return (int)((float)s + f.floatValue() * (float)(t - s));
        }
        return super.getX();
    }

    @Override
    public String getFriendlyName() {
        return (String)this.getPropertyValue("#name.tag");
    }
}

