/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.engine.Option;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Property;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EngineSettings
extends Element {
    public EngineSettings(Element prototype) {
        super(prototype);
    }

    @Override
    public String getFriendlyName() {
        return "settings";
    }

    public boolean isSet(String name) {
        return this.isPropertyLocal(name);
    }

    public boolean allDefault() {
        if (this.properties == null || this.properties.isEmpty()) {
            return true;
        }
        for (Map.Entry key_value : this.properties.entrySet()) {
            String key = (String)key_value.getKey();
            Property property = (Property)key_value.getValue();
            if (property.getValue().equals(this.prototype.getPropertyValue(key))) continue;
            return false;
        }
        return true;
    }

    public void resetToDefault(String name) {
        this.setProperty(name, null);
    }

    public void resetToDefault(List<String> names) {
        for (String name : names) {
            this.resetToDefault(name);
        }
    }

    public String getValue(String name) {
        return (String)this.getPropertyValue(name);
    }

    public <T> T getValue(Option<T> option) {
        String value = (String)this.getPropertyValue(option.getName());
        if (value == null) {
            return option.getDefaultValue();
        }
        return option.fromString(value);
    }

    protected void populateChange(String name, String value) {
        if ("--diagnostic".equals(name) && "0".equals(value)) {
            if ("3".equals(this.getValue("--state-representation"))) {
                this.setValue("--state-representation", "0");
            }
        } else if ("--state-representation".equals(name) && "3".equals(value)) {
            if ("0".equals(this.getValue("--diagnostic"))) {
                this.setValue("--diagnostic", "0");
            }
        } else if ("--state-representation".equals(name) && "2".equals(value)) {
            if ("1".equals(this.getValue("--reuse"))) {
                this.setValue("--reuse", "0");
            }
        } else if ("--reuse".equals(name) && "1".equals(value) && "2".equals(this.getValue("--state-representation"))) {
            this.setValue("--state-representation", "0");
        }
    }

    public <T> void setValue(Option<T> option, T value) {
        if (Objects.equals(option.getDefaultValue(), value)) {
            this.setProperty(option.getName(), null);
        } else {
            this.setProperty(option.getName(), value.toString());
        }
    }

    public void setValue(String name, String value) {
        this.setProperty(name, value);
    }

    public EngineSettings copy() {
        try {
            EngineSettings settings = new EngineSettings(this.prototype);
            this.copyInto(settings);
            return settings;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

