/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CommandManager;
import com.uppaal.model.core2.DocumentPrototype;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EngineSettings;
import com.uppaal.model.core2.InsertElementCommand;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.PlotConfiguration;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.TrajectoryList;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.io2.BoundCalc;
import com.uppaal.model.io2.CachedOutputStream;
import com.uppaal.model.io2.FullXMLWriter;
import com.uppaal.model.io2.XTAWriter;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Document
extends Node {
    public static final String SETTINGS = "settings";
    public static final String SETTINGS_CHANGED = "#settingsChanged";
    public static final String CONCRETE_SIMULATOR_PLOTS = "concrete-sim-plots";
    private static final Pattern node = Pattern.compile("(\\w+)(\\[((\\d+)|@kind=\"(\\w+)\")\\])?");
    public static final String[] labelKinds = new String[]{"invariant", "exponentialrate", "comments", "select", "guard", "synchronisation", "assignment", "probability", "message", "condition", "update", "name"};

    public Document() {
        super(null);
    }

    public Document(Element prototype) {
        super(prototype);
        this.insert(new QueryList(this), this.getLast());
        this.setHorizonList(new TrajectoryList(this));
        this.setCommandManager(new CommandManager());
    }

    public static Document load(String location) throws IOException {
        new DocumentPrototype();
        return DocumentPrototype.load(location);
    }

    public EngineSettings getSettings() {
        return (EngineSettings)this.getPropertyValue(SETTINGS);
    }

    public final void setSettings(EngineSettings settings) {
        this.setProperty(SETTINGS, settings);
    }

    public void setHorizonList(TrajectoryList list) {
        Optional<TrajectoryList> old = this.getFirstInstance(TrajectoryList.class);
        if (old.isPresent()) {
            this.insert(list, old.get());
            old.get().remove();
        } else {
            this.insert(list, this.getLast());
        }
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCommandManager().getVersion());
        sb.append(',');
        this.addSubVersion(sb, this.getLocalProperty("declaration"));
        for (Node n = this.getFirst(); n != null; n = n.getNext()) {
            if (!(n instanceof AbstractTemplate)) continue;
            this.addSubVersion(sb, n);
            this.addSubVersion(sb, n.getLocalProperty("declaration"));
        }
        this.addSubVersion(sb, this.getLocalProperty("system"));
        return sb.toString();
    }

    private void addSubVersion(StringBuilder sb, Element element) {
        if (element == null || element.getCommandManager() == null) {
            sb.append("1,");
        } else {
            sb.append(element.getCommandManager().getVersion());
            sb.append(',');
        }
    }

    public QueryList getQueryList() {
        return this.getFirstInstance(QueryList.class).orElse(null);
    }

    public TrajectoryList getTrajectoryList() {
        return this.getFirstInstance(TrajectoryList.class).orElse(null);
    }

    public Template createTemplate() {
        return new Template((Element)this.getPropertyValue("#template"));
    }

    public Template addTemplate() {
        Template t = new Template((Element)this.getPropertyValue("#template"));
        this.insert(t, this.getLastTATemplate());
        return t;
    }

    public LscTemplate createLscTemplate() {
        return new LscTemplate((Element)this.getPropertyValue("#lscTemplate"));
    }

    public AbstractTemplate getTemplates() {
        return (AbstractTemplate)this.first;
    }

    public List<AbstractTemplate> getTemplateList() {
        ArrayList<AbstractTemplate> templates = new ArrayList<AbstractTemplate>();
        for (Node child = this.getFirst(); child != null; child = child.getNext()) {
            if (!(child instanceof AbstractTemplate)) continue;
            templates.add((AbstractTemplate)child);
        }
        return templates;
    }

    public AbstractTemplate findTemplate(String name) {
        if (name == null) {
            return null;
        }
        AbstractTemplate t = this.getTemplates();
        while (t != null && !name.equals(t.getPropertyValue("name"))) {
            Node n = t.getNext();
            t = n instanceof AbstractTemplate ? (AbstractTemplate)n : null;
        }
        return t;
    }

    public AbstractTemplate getLastTATemplate() {
        Node lastTemplate = null;
        for (Node child = this.getFirst(); child != null; child = child.getNext()) {
            if (!(child instanceof Template)) continue;
            lastTemplate = child;
        }
        return lastTemplate == null ? null : (AbstractTemplate)lastTemplate;
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitDocument(this);
    }

    @Override
    public Document getDocument() {
        return this;
    }

    private Node getChild(Element element, int index, Class<?> c) {
        Node child;
        if (!(element instanceof Node)) {
            return null;
        }
        for (child = ((Node)element).getFirst(); child != null && !c.isInstance(child); child = child.getNext()) {
        }
        while (child != null && index > 1) {
            while ((child = child.getNext()) != null && !c.isInstance(child)) {
            }
            --index;
        }
        return child;
    }

    public Element resolveXPath(String path) {
        Scanner scanner = new Scanner(path);
        Element current = this;
        block64: while (scanner.hasNext() && current != null) {
            scanner.findInLine(node);
            MatchResult result = scanner.match();
            String token = result.group(1);
            String s = result.group(4);
            int index = s == null ? 1 : Integer.parseInt(s);
            String kind = result.group(5);
            switch (token) {
                case "project": {
                    current = this;
                    continue block64;
                }
                case "nta": {
                    current = this;
                    continue block64;
                }
                case "declaration": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "template": {
                    current = this.getChild(current, index, Template.class);
                    continue block64;
                }
                case "instantiation": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "system": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "name": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "parameter": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "location": {
                    current = this.getChild(current, index, Location.class);
                    continue block64;
                }
                case "branchpoint": {
                    current = this.getChild(current, index, BranchPoint.class);
                    continue block64;
                }
                case "init": {
                    continue block64;
                }
                case "transition": {
                    current = this.getChild(current, index, Edge.class);
                    continue block64;
                }
                case "label": {
                    String[] kinds = new String[]{"invariant", "exponentialrate", "comments", "select", "guard", "synchronisation", "assignment", "probability", "message", "condition", "update"};
                    if (kind != null) {
                        current = current.getLocalProperty(kind);
                        continue block64;
                    }
                    Property child = null;
                    for (String k : kinds) {
                        if (!current.isPropertyLocal(k)) continue;
                        if (index == 1) {
                            child = current.getProperty(k);
                        }
                        --index;
                    }
                    current = child;
                    continue block64;
                }
                case "urgent": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "source": {
                    continue block64;
                }
                case "target": {
                    continue block64;
                }
                case "nail": {
                    current = this.getChild(current, index, Nail.class);
                    continue block64;
                }
                case "lscTemplate": {
                    current = this.getChild(current, index, LscTemplate.class);
                    continue block64;
                }
                case "type": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "mode": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "role": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "yloccoord": {
                    continue block64;
                }
                case "instance": {
                    current = this.getChild(current, index, InstanceLine.class);
                    continue block64;
                }
                case "prechart": {
                    current = this.getChild(current, index, Prechart.class);
                    continue block64;
                }
                case "message": {
                    current = this.getChild(current, index, Message.class);
                    continue block64;
                }
                case "condition": {
                    current = this.getChild(current, index, Condition.class);
                    continue block64;
                }
                case "update": {
                    current = this.getChild(current, index, Update.class);
                    continue block64;
                }
                case "anchor": {
                    continue block64;
                }
                case "temperature": {
                    current = current.getProperty(token);
                    continue block64;
                }
                case "lsclocation": {
                    current = current.getProperty(token);
                    continue block64;
                }
            }
            return null;
        }
        return current;
    }

    public void save(File file) throws IOException {
        block9: {
            CachedOutputStream out = new CachedOutputStream(file);
            OutputStream ugi = null;
            try {
                String s = file.getName().toLowerCase();
                if (s.endsWith(".xml")) {
                    this.saveXML(out);
                    break block9;
                }
                if (s.endsWith(".xta")) {
                    File ugiFile = new File(file.getAbsoluteFile().getParentFile(), s.replaceFirst(".xta$", ".ugi"));
                    ugi = new CachedOutputStream(ugiFile);
                    this.saveXTA(out, ugi);
                    break block9;
                }
                throw new IOException("The file extension was not recognised (Only .xml and .xta are supported).");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                ((OutputStream)out).close();
                if (ugi != null) {
                    ugi.close();
                }
            }
        }
    }

    public void saveXML(OutputStream out) throws IOException {
        try {
            this.accept(new FullXMLWriter(out));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException(e.getMessage());
        }
    }

    public void saveXTA(OutputStream xta, OutputStream ugi) throws IOException {
        try {
            XTAWriter writer = new XTAWriter(xta);
            this.accept(writer);
            if (ugi != null) {
                this.accept(writer.createUGIWriter(ugi));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public static boolean merge(AbstractTemplate source, AbstractTemplate target) {
        ArrayList<InsertElementCommand> cmd = new ArrayList<InsertElementCommand>();
        if (target instanceof Template) {
            if (source instanceof Template) {
                Node child;
                BoundCalc measurer = new BoundCalc();
                Rectangle2D tb = measurer.getBounds(target);
                Rectangle2D sb = measurer.getBounds(source);
                if (sb != null && tb != null) {
                    final int dx = (int)Math.round(tb.getMaxX() - sb.getMinX());
                    final int dy = (int)Math.round(tb.getMinY() - sb.getMinY());
                    source.acceptSafe(new AbstractVisitor(){

                        @Override
                        public void visitElement(Element element) throws Exception {
                            super.visitElement(element);
                            if (element.isPropertyLocal("x")) {
                                element.setProperty("x", element.getX() + dx);
                            }
                            if (element.isPropertyLocal("y")) {
                                element.setProperty("y", element.getY() + dy);
                            }
                        }
                    });
                }
                boolean initExists = false;
                for (child = target.getFirst(); child != null; child = child.getNext()) {
                    if (!child.hasFlag("init")) continue;
                    initExists = true;
                }
                child = source.getFirst();
                while (child != null) {
                    child.remove();
                    child.importInto(target);
                    if (initExists && child.hasFlag("init")) {
                        child.setProperty("init", null);
                    }
                    cmd.add(new InsertElementCommand(target.getCommandManager(), target, target.getLast(), child));
                    child = source.getFirst();
                }
                if (cmd.isEmpty()) {
                    return false;
                }
                Command[] commands = cmd.toArray(new Command[cmd.size()]);
                target.getCommandManager().execute(commands);
                return true;
            }
        } else if (target instanceof LscTemplate && source instanceof LscTemplate) {
            return false;
        }
        return false;
    }

    public void save(String path) throws IOException {
        this.save(new File(path));
    }

    @Override
    public String getXPathTag() {
        return "/nta";
    }

    @Override
    public String getFriendlyName() {
        return "Project";
    }

    public List<PlotConfiguration> getConcretePlots() {
        return (List)this.getPropertyValue(CONCRETE_SIMULATOR_PLOTS);
    }

    public void setConcretePlots(List<PlotConfiguration> plots) {
        this.getCommandManager().execute((Command)new SetPropertyCommand(this, CONCRETE_SIMULATOR_PLOTS, plots));
    }
}

