/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.LogIterator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Data2D
implements Iterable<Point2D.Double> {
    public static final Point2D.Double emptyMin = new Point2D.Double(0.0, 0.0);
    public static final Point2D.Double emptyMax = new Point2D.Double(0.0, 0.0);
    String title;
    String type;
    Color color;
    Point2D.Double min;
    Point2D.Double max;
    Point2D.Double logmin;
    Point2D.Double logmax;
    double dx;
    double logdx;
    boolean logx = false;
    boolean logy = false;
    ArrayList<Point2D.Double> samples = new ArrayList();

    public Data2D(String title, String type, Color color) {
        int till;
        this.title = title;
        this.type = type;
        this.color = color;
        this.min = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.max = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.logmin = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.logmax = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.dx = Double.POSITIVE_INFINITY;
        this.logdx = Double.POSITIVE_INFINITY;
        int b = type.indexOf(98);
        if (b >= 0 && b < type.length() - 2 && type.charAt(b + 1) == '(' && (till = type.indexOf(41, b += 2)) > b + 1) {
            try {
                this.dx = Double.parseDouble(type.substring(b, till));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateMinMax(Point2D.Double p) {
        this.min.x = this.min.x < p.x ? this.min.x : p.x;
        this.min.y = this.min.y < p.y ? this.min.y : p.y;
        this.max.x = this.max.x > p.x ? this.max.x : p.x;
        this.max.y = this.max.y > p.y ? this.max.y : p.y;
    }

    private void updateMinMax() {
        this.min = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.max = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (Point2D.Double p : this.samples) {
            this.updateMinMax(p);
        }
    }

    public void addSample(Point2D.Double p) {
        this.updateMinMax(p);
        double lx = Math.log10(p.x);
        double ly = Math.log10(p.y);
        if (p.x > 0.0 && lx < this.logmin.x) {
            this.logmin.x = lx;
        }
        if (p.y > 0.0 && ly < this.logmin.y) {
            this.logmin.y = ly;
        }
        if (p.x > 0.0 && lx > this.logmax.x) {
            this.logmax.x = lx;
        }
        if (p.y > 0.0 && ly > this.logmax.y) {
            this.logmax.y = ly;
        }
        if (!this.samples.isEmpty()) {
            Point2D.Double p2 = this.samples.get(this.samples.size() - 1);
            double d = Math.abs(p2.x - p.x);
            if (d > 0.0 && d < this.dx) {
                this.dx = d;
            }
            if ((d = Math.abs(Math.log10(p2.x) - Math.log10(p.x))) > 0.0 && d < this.logdx) {
                this.logdx = d;
            }
        }
        this.samples.add(p);
    }

    public void addSample(double x, double y) {
        this.addSample(new Point2D.Double(x, y));
    }

    public Color getColor() {
        return this.color;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public void setColor(Color newcolor) {
        this.color = newcolor;
    }

    public void setTitle(String newtitle) {
        this.title = newtitle;
    }

    public void setType(String newtype) {
        this.type = newtype;
    }

    public void setLogX(boolean logx) {
        this.logx = logx;
    }

    public void setLogY(boolean logy) {
        this.logy = logy;
    }

    public double getXMinDifference() {
        if (this.logx) {
            return this.logdx;
        }
        return this.dx;
    }

    public Point2D.Double getNearestSampleAt(double x) {
        int i;
        if (this.samples.isEmpty()) {
            return null;
        }
        if (this.logx) {
            x = Math.pow(10.0, x);
        }
        if ((i = (int)Math.floor((x - this.min.x) / this.dx)) >= this.samples.size()) {
            i = this.samples.size() - 1;
        }
        if (i < 0) {
            i = 0;
        }
        Point2D.Double p = this.samples.get(i);
        while (x < p.x && i > 0) {
            p = this.samples.get(--i);
        }
        while (x > p.x + this.dx && i < this.samples.size() - 1) {
            p = this.samples.get(++i);
        }
        return p;
    }

    @Override
    public Iterator<Point2D.Double> iterator() {
        if (this.logx || this.logy) {
            return new LogIterator(this.samples.iterator(), this.logx, this.logy);
        }
        return this.samples.iterator();
    }

    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    public Point2D.Double getMinimum() {
        if (this.samples.isEmpty()) {
            return new Point2D.Double(Data2D.emptyMin.x, Data2D.emptyMin.y);
        }
        return new Point2D.Double(this.logx ? this.logmin.x : this.min.x, this.logy ? this.logmin.y : this.min.y);
    }

    public Point2D.Double getMaximum() {
        if (this.samples.isEmpty()) {
            return new Point2D.Double(Data2D.emptyMax.x, Data2D.emptyMax.y);
        }
        return new Point2D.Double(this.logx ? this.logmax.x : this.max.x, this.logy ? this.logmax.y : this.max.y);
    }

    public void removeAbove(double x) {
        Point2D.Double closestBeforePoint = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Point2D.Double closestAfterPoint = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point2D.Double closestBeforeOriginal = closestBeforePoint;
        Point2D.Double closestAfterOriginal = closestAfterPoint;
        for (Point2D.Double p : this.samples) {
            if (p.x >= x && p.x < closestAfterPoint.x) {
                closestAfterPoint = p;
            }
            if (!(p.x < x) || !(p.x >= closestBeforePoint.x)) continue;
            closestBeforePoint = p;
        }
        this.samples.removeIf(point -> point.getX() >= x);
        if (closestBeforeOriginal != closestBeforePoint && closestAfterOriginal != closestAfterPoint) {
            double gradient = (closestAfterPoint.y - closestBeforePoint.y) / (closestAfterPoint.x - closestBeforePoint.x);
            double distance = x - closestBeforePoint.x;
            Point2D.Double newPoint = new Point2D.Double(x, closestBeforePoint.y + distance * gradient);
            this.addSample(newPoint);
        }
        this.updateMinMax();
    }

    public int size() {
        return this.samples.size();
    }

    public double getArg() {
        try {
            Pattern p = Pattern.compile("\\((\\d+\\.?\\d*)\\)");
            Matcher m = p.matcher(this.type);
            m.find();
            return Double.parseDouble(m.group(1));
        }
        catch (IllegalStateException | NumberFormatException e) {
            return -1.0;
        }
    }

    public static enum AreaStyle {
        Bars,
        Polygon,
        None;

    }

    public static enum LineStyle {
        Solid,
        Dashed,
        Dotted,
        DashDotted,
        None;

    }

    public static enum PointStyle {
        Dot,
        Diamond,
        TriangleUp,
        TriangleDown,
        TriangleLeft,
        TriangleRight,
        Rectangle,
        Circle,
        None;

    }
}

