/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractCommand;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class CollapsableCommand
extends AbstractCommand {
    private final boolean allowCollapse;
    protected final Property property;
    protected List<Command> commands;

    public CollapsableCommand(boolean allowCollapse, Property property) {
        this.allowCollapse = allowCollapse;
        this.property = property;
    }

    @Override
    public void execute() {
        if (this.commands != null) {
            for (Command command : this.commands) {
                command.execute();
            }
        }
    }

    @Override
    public void undo() {
        if (this.commands != null) {
            for (int i = this.commands.size() - 1; i >= 0; --i) {
                this.commands.get(i).undo();
            }
        }
    }

    @Override
    public boolean merge(Command next) {
        if (next instanceof CollapsableCommand) {
            CollapsableCommand other = (CollapsableCommand)next;
            if (other.allowCollapse && this.getModifiedElement() == other.getModifiedElement()) {
                if (this.commands == null) {
                    this.commands = new ArrayList<Command>();
                }
                this.commands.add(other);
                return true;
            }
        }
        if (this.commands != null) {
            return this.commands.get(this.commands.size() - 1).merge(next);
        }
        return false;
    }

    public Optional<Command> getLast() {
        if (this.commands != null) {
            return Optional.of(this.commands.get(this.commands.size() - 1));
        }
        return Optional.empty();
    }

    @Override
    public Element getModifiedElement() {
        return this.property;
    }
}

