/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model;

import com.uppaal.model.AbstractSystemLocation;
import com.uppaal.model.system.Polyhedron;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public abstract class AbstractSystemState {
    private final int[] variables;
    private final Polyhedron zone;

    public AbstractSystemState(int[] v, Polyhedron z) {
        this.variables = v;
        this.zone = z;
    }

    public void writeServerFormat(Writer writer) throws IOException {
        AbstractSystemLocation[] locations;
        for (AbstractSystemLocation location : locations = this.getLocationVector()) {
            writer.write(String.valueOf(location.getIndex()));
            writer.write(10);
        }
        writer.write(".\n");
        this.zone.writeTextualFormat(writer);
        for (int i : this.variables) {
            writer.write(String.valueOf(i));
            writer.write(10);
        }
        writer.write(46);
    }

    public void writeXTRFormat(Writer writer) throws IOException {
        this.writeServerFormat(writer);
        writer.write(10);
    }

    public String traceFormat() {
        AbstractSystemLocation[] locations;
        StringBuilder s = new StringBuilder("(");
        boolean first = true;
        for (AbstractSystemLocation location : locations = this.getLocationVector()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            String name = location.getName();
            s.append(name == null || name.length() == 0 ? "-" : name);
        }
        s.append(")");
        return s.toString();
    }

    public Polyhedron getPolyhedron() {
        return this.zone;
    }

    public int[] getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        AbstractSystemState s = (AbstractSystemState)obj;
        return Arrays.equals(this.getLocationVector(), s.getLocationVector()) && Arrays.equals(this.variables, s.variables) && this.zone.equals(s.zone);
    }

    public abstract AbstractSystemLocation[] getLocationVector();
}

