/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.language;

import com.uppaal.engine.BinaryResolution;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.ExecutableValidator;
import com.uppaal.engine.SwingFuture;
import com.uppaal.engine.connection.CommandConnection;
import com.uppaal.language.Protocol;
import com.uppaal.language.Suggestion;
import com.uppaal.model.OSUtils;
import com.uppaal.model.core2.Document;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class LanguageServer {
    private static BinaryResolution binaryResolution;
    private static LanguageServer instance;
    private CommandConnection connection;
    private ExecutorService executor;
    private Protocol protocol;

    private LanguageServer() {
    }

    private LanguageServer(File languageServer) {
        this.connection = new CommandConnection("ULS connection", new String[]{languageServer.getAbsolutePath()});
        this.executor = Executors.newSingleThreadExecutor();
    }

    public static void disable() {
        instance = new LanguageServer();
    }

    public static void setBinaryResolutionStrategy(BinaryResolution resolutionStrategy) {
        binaryResolution = resolutionStrategy;
    }

    public static Optional<LanguageServer> initializedInstance() {
        LanguageServer server = LanguageServer.getOrCreateInstance();
        if (server != null && server.isInitialized()) {
            return Optional.of(server);
        }
        return Optional.empty();
    }

    private static LanguageServer getOrCreateInstance() {
        if (instance == null) {
            Optional<File> uls = LanguageServer.findExecutable();
            if (uls.isPresent()) {
                LanguageServer.launchServer(uls.get());
            } else {
                LanguageServer.disable();
            }
        }
        return instance;
    }

    private static Optional<File> findExecutable() {
        ExecutableValidator validator = new ExecutableValidator("exit");
        return Objects.requireNonNull(binaryResolution).search(LanguageServer.executableName(), validator::isValid);
    }

    private static void launchServer(File uls) {
        try {
            instance = new LanguageServer(uls);
            instance.checkAvailability();
        }
        catch (Exception e) {
            instance = new LanguageServer();
            LanguageServer.instance.connection = null;
            LanguageServer.instance.executor = null;
            throw new RuntimeException("Failed to start language server", e);
        }
    }

    private static String executableName() {
        return OSUtils.getOS() == OSUtils.OS.WIN ? "uls.exe" : "uls";
    }

    public boolean isInitialized() {
        return this.connection != null;
    }

    public SwingFuture<Void> upload(Document document) {
        SwingFuture<Void> future = new SwingFuture<Void>();
        this.submit(() -> {
            if (future.isCancelled()) {
                return;
            }
            try {
                this.protocol.upload(document);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public SwingFuture<Void> setCurrentNode(String xpath) {
        SwingFuture<Void> future = new SwingFuture<Void>();
        this.submit(() -> {
            try {
                this.protocol.setCurrentNode(xpath);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public SwingFuture<List<Suggestion>> autocomplete(String xpath, String identifier, int offset) {
        SwingFuture<List<Suggestion>> future = new SwingFuture<List<Suggestion>>();
        this.submit(() -> {
            if (future.isCancelled()) {
                return;
            }
            try {
                ArrayList<Suggestion> suggestions = this.protocol.autocomplete(xpath, identifier, offset);
                if (future.isCancelled()) {
                    return;
                }
                if (suggestions != null) {
                    future.complete(suggestions);
                } else {
                    future.complete(Collections.emptyList());
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kill() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.connection.isConnected()) {
            this.executor.submit(this::silentClose);
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(10L, TimeUnit.MILLISECONDS)) return;
                this.connection.kill();
                return;
            }
            catch (InterruptedException ignored) {
                this.connection.kill();
                return;
            }
            finally {
                this.executor = null;
                this.connection = null;
                this.protocol = null;
            }
        } else {
            this.executor = null;
            this.connection = null;
            this.protocol = null;
        }
    }

    private void silentClose() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void submit(Runnable task) {
        try {
            this.checkAvailability();
            this.executor.execute(task);
        }
        catch (EngineException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkAvailability() throws EngineException, IOException {
        if (!this.isInitialized()) {
            throw new RuntimeException("Language server must be initialized before use");
        }
        if (!this.connection.isConnected()) {
            this.protocol = Protocol.handshake(this.connection.connect());
        }
    }
}

