/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.viewmodel;

import com.google.gson.annotations.SerializedName;
import com.uppaal.engine.protocol.viewmodel.DBMConstraintViewModel;
import com.uppaal.model.AbstractSystemLocation;
import com.uppaal.model.system.symbolic.SymbolicState;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SymbolicStateViewModel {
    @SerializedName(value="locs")
    List<Integer> locations;
    @SerializedName(value="dbm")
    List<DBMConstraintViewModel> dbm;
    @SerializedName(value="vars")
    List<Integer> variableValues;

    public List<Integer> getLocations() {
        return this.locations;
    }

    public List<Integer> getVariableValues() {
        return this.variableValues;
    }

    public List<DBMConstraintViewModel> getDbm() {
        return this.dbm;
    }

    public SymbolicStateViewModel() {
    }

    public SymbolicStateViewModel(SymbolicState state) {
        this.locations = Arrays.stream(state.getLocations()).map(AbstractSystemLocation::getIndex).collect(Collectors.toList());
        this.dbm = state.getPolyhedron().getRawConstraintList().stream().map(cons -> new DBMConstraintViewModel(cons.i, cons.j, cons.bound ^ 1)).collect(Collectors.toList());
        this.variableValues = Arrays.stream(state.getVariableValues()).boxed().collect(Collectors.toList());
    }
}

