/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.viewmodel;

import com.google.gson.annotations.SerializedName;
import com.uppaal.model.system.SystemEdgeSelect;
import java.util.ArrayList;
import java.util.List;

public class EdgeFieldViewModel {
    @SerializedName(value="parts")
    private List<EdgePart> edgeParts = new ArrayList<EdgePart>();

    public EdgeFieldViewModel() {
    }

    public void addEdgePart(EdgePart part) {
        this.edgeParts.add(part);
    }

    public EdgeFieldViewModel(SystemEdgeSelect edge) {
        this.edgeParts.add(new EdgePart(edge.getProcess().getIndex(), edge.getIndex(), edge.getSelectList()));
    }

    public List<EdgePart> getEdgeParts() {
        return this.edgeParts;
    }

    public static class EdgePart {
        @SerializedName(value="procnum")
        private int processId;
        @SerializedName(value="eid")
        private int edgeId;
        @SerializedName(value="sel_vals")
        private List<Integer> selectValues;

        public EdgePart() {
        }

        public EdgePart(int processId, int edgeId, List<Integer> selectValues) {
            this.processId = processId;
            this.edgeId = edgeId;
            this.selectValues = selectValues;
        }

        public int getProcessId() {
            return this.processId;
        }

        public int getEdgeId() {
            return this.edgeId;
        }

        public List<Integer> getSelectValues() {
            return this.selectValues;
        }
    }
}

