/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class AbstractTypeAdapter {
    public <T> T parse(Class<T> classType, JsonElement json, JsonDeserializationContext context) {
        if (json == null || context == null) {
            throw new RuntimeException("AbstractTypeAdapter isn't initialized correctly");
        }
        try {
            T obj = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : classType.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                String variableName = field.getName();
                String serializedName = null;
                if (field.isAnnotationPresent(SerializedName.class)) {
                    serializedName = field.getAnnotation(SerializedName.class).value();
                }
                if (serializedName != null) {
                    field.set(obj, context.deserialize(json.getAsJsonObject().get(serializedName), field.getGenericType()));
                    continue;
                }
                field.set(obj, context.deserialize(json.getAsJsonObject().get(variableName), field.getGenericType()));
            }
            return obj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

