/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.connection;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.connection.Connection;
import com.uppaal.engine.connection.InitialConnection;
import com.uppaal.engine.connection.ServerUnavailableException;
import com.uppaal.model.OSUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CommandConnection
extends Connection {
    private final String[] preSplitCommand;
    private final String command;
    private Process process;

    public CommandConnection(String name, String[] command) {
        super(name);
        this.preSplitCommand = command;
        this.command = "";
    }

    public CommandConnection(String name, String command) {
        super(name);
        this.command = command;
        this.preSplitCommand = new String[0];
    }

    private static String[] splitGeneric(String command, char escapeChar) {
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder current = new StringBuilder(command.length());
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c == ' ') {
                if (singleQuoted || doubleQuoted) {
                    current.append(' ');
                    continue;
                }
                split.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (c == '\'') {
                if (doubleQuoted) {
                    current.append('\'');
                    continue;
                }
                singleQuoted = !singleQuoted;
                continue;
            }
            if (c == '\"') {
                if (singleQuoted) {
                    current.append('\"');
                    continue;
                }
                doubleQuoted = !doubleQuoted;
                continue;
            }
            if (c != escapeChar) {
                current.append(c);
                continue;
            }
            char next = command.charAt(i + 1);
            ++i;
            if (next == ' ') {
                current.append(' ');
                continue;
            }
            if (next == escapeChar) {
                current.append(escapeChar);
                continue;
            }
            if (next == '\"') {
                current.append('\"');
                continue;
            }
            if (next == '\'') {
                current.append('\'');
                continue;
            }
            throw new RuntimeException("Invalid escape sequence \\" + next);
        }
        if (singleQuoted || doubleQuoted) {
            throw new RuntimeException("Unclosed quote");
        }
        split.add(current.toString());
        return split.toArray(new String[0]);
    }

    public static String[] splitUnix(String command) {
        return CommandConnection.splitGeneric(command, '\\');
    }

    public static String[] splitWindows(String command) {
        if (command.indexOf(96) >= 0) {
            return CommandConnection.splitGeneric(command, '`');
        }
        return CommandConnection.splitGeneric(command, '^');
    }

    public static String joinCommand(String[] command) {
        String escapedSpace = OSUtils.getOS() == OSUtils.OS.WIN ? "` " : "\\ ";
        return String.join((CharSequence)" ", (CharSequence[])Arrays.stream(command).map(x -> x.replace(" ", escapedSpace)).toArray(String[]::new));
    }

    public static String[] split(String command) {
        switch (OSUtils.getOS()) {
            case LINUX: 
            case MACOS: 
            case SUNOS: {
                return CommandConnection.splitUnix(command);
            }
            case WIN: {
                return CommandConnection.splitWindows(command);
            }
        }
        throw new RuntimeException("Unsupported operating system");
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public InitialConnection connect() throws EngineException {
        try {
            ProcessBuilder pb = new ProcessBuilder(this.preSplitCommand.length > 0 ? this.preSplitCommand : CommandConnection.split(this.command));
            Map<String, String> env = pb.environment();
            env.put("LD_LIBRARY_PATH", System.getProperty("java.library.path"));
            this.process = pb.start();
            OutputStream out = this.process.getOutputStream();
            InputStream in = this.process.getInputStream();
            final InputStream err = this.process.getErrorStream();
            if (in == null || out == null || err == null) {
                int v = this.process.exitValue();
                throw new EngineException("Engine stopped with error code " + v);
            }
            final StringBuffer errors = new StringBuffer();
            new Thread("ServerErrorStream"){

                @Override
                public void run() {
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(err, StandardCharsets.UTF_8));
                    try {
                        String line;
                        while ((line = errorReader.readLine()) != null) {
                            System.err.println(line);
                            errors.append(line).append(System.lineSeparator());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            BufferedWriter bufferedOut = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            return new InitialConnection(in, bufferedOut);
        }
        catch (IOException e) {
            throw new ServerUnavailableException(e.getMessage());
        }
        catch (IllegalThreadStateException e) {
            throw new EngineException("Could not get I/O streams from engine.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.process != null) {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                Thread t = new Thread("EngineWaiter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            CommandConnection.this.process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                };
                t.start();
                try {
                    lock.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.process.destroy();
                this.process = null;
            }
        }
    }

    @Override
    public void kill() {
        if (!this.isConnected()) {
            return;
        }
        this.process.destroy();
        this.process = null;
    }

    @Override
    public boolean isConnected() {
        return this.process != null && this.process.isAlive();
    }

    @Override
    public String getErrorStream() {
        if (this.process.getErrorStream() == null) {
            return "";
        }
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.process.getErrorStream().transferTo(result);
            return result.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection clone() {
        if (this.preSplitCommand.length > 0) {
            return new CommandConnection(this.getName(), this.preSplitCommand);
        }
        return new CommandConnection(this.getName(), this.command);
    }
}

