/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.Range;
import java.util.ArrayList;
import java.util.List;

public class RangeSet {
    private final List<Range> ranges;

    public RangeSet(List<Range> ranges) {
        this.ranges = ranges;
        double lastEnd = -1.0;
        for (Range r : ranges) {
            assert (r.start > lastEnd) : "RangeSet assumes ranges are increasing";
            lastEnd = r.end;
        }
    }

    public RangeSet(Range range) {
        this.ranges = new ArrayList<Range>();
        this.ranges.add(range);
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public Range getContainingRange(double d) {
        for (Range r : this.ranges) {
            if (!(r.start <= d) || !(d <= r.end)) continue;
            return r;
        }
        return null;
    }

    public boolean contains(double d) {
        return this.getContainingRange(d) != null;
    }

    public Range getClosestRange(double d) {
        assert (this.ranges.size() > 0);
        double shortestDistance = Double.POSITIVE_INFINITY;
        Range closestRange = this.ranges.get(0);
        for (Range r : this.ranges) {
            double distanceEnd;
            double distanceStart = Math.abs(d - r.start);
            if (distanceStart < shortestDistance) {
                shortestDistance = distanceStart;
                closestRange = r;
            }
            if (!((distanceEnd = Math.abs(d - r.end)) < shortestDistance)) continue;
            shortestDistance = distanceEnd;
            closestRange = r;
        }
        return closestRange;
    }

    public double getStart() {
        assert (this.ranges.size() > 0);
        return this.ranges.get((int)0).start;
    }

    public double getEnd() {
        assert (this.ranges.size() > 0);
        return this.ranges.get((int)(this.ranges.size() - 1)).end;
    }
}

