/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.protocol.ParseException;
import com.uppaal.engine.protocol.viewmodel.RandomTransitionQuery;
import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.io2.Problem;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.RandomTransition;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.IOException;
import java.util.ArrayList;

public interface Protocol {
    public void close() throws IOException;

    public String getVersion() throws IOException, EngineException;

    public String getOptionsInfo() throws EngineException, IOException;

    public void setOptions(String var1) throws EngineException, IOException;

    public SymbolicState getSymbolicInitial(UppaalSystem var1) throws EngineException, IOException, CannotEvaluateException;

    public ConcreteState getConcreteInitial(UppaalSystem var1) throws EngineException, IOException, CannotEvaluateException;

    public ConcreteSuccessor getConcreteSuccessor(UppaalSystem var1, ConcreteState var2, SystemEdgeSelect[] var3, double var4, double var6) throws EngineException, IOException, CannotEvaluateException;

    public RandomTransition getRandomTransition(UppaalSystem var1, ConcreteState var2, RandomTransitionQuery.RandomSemantics var3, double var4) throws Exception;

    public DataSet2D getConcreteTrajectory(UppaalSystem var1, ConcreteState var2, double var3) throws ProtocolException, IOException, ParseException;

    public ArrayList<SymbolicTransition> getTransitions(UppaalSystem var1, SymbolicState var2) throws EngineException, IOException, CannotEvaluateException;

    public UppaalSystem upload(Document var1, ArrayList<Problem> var2) throws EngineException, IOException;

    public LscProcess uploadLsc(Document var1, ArrayList<Problem> var2) throws EngineException, IOException;

    public UppaalSystem upload(Document var1) throws EngineException, IOException;

    public QueryResult query(UppaalSystem var1, Query var2, QueryFeedback var3) throws EngineException, IOException;

    public QueryResult query(UppaalSystem var1, SymbolicState var2, Query var3, QueryFeedback var4) throws EngineException, IOException, CannotEvaluateException;

    public void cancel();

    public void setStrategy(String var1, boolean var2);

    public ArrayList<String> getStrategies(boolean var1);

    public String getLicensee() throws IOException, ProtocolException, ParseException;

    public String getLeaseRequest(String var1, String var2) throws IOException, ProtocolException, ParseException;

    public String installLease(String var1) throws IOException, ProtocolException, ParseException;

    public String getStrategy(String var1) throws IOException, ProtocolException;
}

