/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.ServerException;
import com.uppaal.model.io2.Problem;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTrace;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class Parser {
    public static final int END = 1;
    public static final int WORD = 2;
    public static final int INT = 4;
    public static final int FLOAT = 7;
    public static final int LONG = 5;
    public static final int NONE = 6;
    public static final int PARTIAL_END = 8;
    private static final char EOS = '\u0000';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static final char SEMICOLON = ';';
    private static String word;
    private int lookahead;
    private char peak;
    private final char[] cb = new char[256];
    private final char[] bb = new char[2048];
    private int offset = 0;
    private int bytes = 0;
    private final InputStreamReader in;
    private static final ResourceBundle locale;

    public Parser(InputStream in) {
        this.in = new InputStreamReader(in, StandardCharsets.UTF_8);
        this.peak = (char)32;
        this.lookahead = 6;
    }

    public int getLookahead() throws IOException {
        if (this.lookahead == 6) {
            this.lookahead = this.nextToken();
        }
        return this.lookahead;
    }

    public String getWord() {
        return word;
    }

    public int getIntValue() {
        return Integer.valueOf(word);
    }

    public long getValue() {
        return Long.valueOf(word);
    }

    public BigDecimal getFloat() {
        return new BigDecimal(word);
    }

    private void fill() throws IOException {
        this.bytes = this.in.read(this.bb, 0, this.bb.length);
        this.offset = 0;
    }

    public String readBlock() throws IOException {
        assert (this.lookahead == 6);
        StringBuilder s = new StringBuilder();
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        while (true) {
            if (this.peak == '.') {
                this.peak = this.read();
                if (this.peak != '.') break;
            }
            s.append(this.peak);
            this.peak = this.read();
        }
        int pos = 0;
        while ((pos = s.indexOf("$", pos)) >= 0) {
            int end;
            int max = s.length();
            block8: for (end = pos + 1; end < max; ++end) {
                switch (s.charAt(end)) {
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ':': {
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            try {
                String v = locale.getString(s.substring(pos + 1, end));
                s.replace(pos, end, v);
                pos += v.length();
            }
            catch (Exception e) {
                ++pos;
            }
        }
        word = s.toString();
        return word;
    }

    public char read() throws IOException {
        char c;
        do {
            if (this.offset != this.bytes) continue;
            this.fill();
            if (this.bytes != -1) continue;
            return '\u0000';
        } while ((c = this.bb[this.offset++]) == '\r');
        return c;
    }

    public int nextToken() throws IOException {
        if (this.lookahead != 6) {
            int token = this.lookahead;
            this.lookahead = 6;
            return token;
        }
        int sign = 1;
        int i = 0;
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        switch (this.peak) {
            case '\u0000': {
                throw new IOException("Server connection lost");
            }
            case '.': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 1;
                }
                this.cb[i++] = 46;
                break;
            }
            case ';': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 8;
                }
                this.cb[i++] = 59;
                break;
            }
            case '-': {
                sign = -1;
                this.cb[i++] = this.peak;
                this.peak = this.read();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int value = 0;
                while (this.peak >= '0' && this.peak <= '9') {
                    value = 10 * value + (this.peak - 48);
                    this.cb[i++] = this.peak;
                    this.peak = this.read();
                }
                if (this.peak == '\u0000' || Character.isWhitespace(this.peak)) {
                    if ((value = sign * value) >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                        word = new String(this.cb, 0, i);
                        return 4;
                    }
                    word = new String(this.cb, 0, i);
                    return 5;
                }
                if (this.peak != '.') break;
                do {
                    this.cb[i++] = this.peak;
                    this.peak = this.read();
                } while (this.peak >= '0' && this.peak <= '9');
                if (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) break;
                word = new String(this.cb, 0, i);
                return 7;
            }
        }
        while (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) {
            this.cb[i++] = this.peak;
            this.peak = this.read();
        }
        word = new String(this.cb, 0, i);
        return 2;
    }

    protected ProtocolException getException(String errorMsg) {
        if (word.equals("error")) {
            return new ProtocolException("Concrete simulation does not currently support SMC");
        }
        return new ProtocolException(errorMsg);
    }

    public void parseProlog() throws EngineException, IOException {
        String response = this.parseId();
        if (response.equals("error")) {
            throw new ServerException(this.readBlock());
        }
        if (!response.equals("ok")) {
            throw new ProtocolException("Bug: Ok expected");
        }
    }

    public String parseId() throws ProtocolException, IOException {
        if (this.nextToken() != 2) {
            throw new ProtocolException("Bug: Word expected");
        }
        return this.getWord();
    }

    public int parseInteger() throws ProtocolException, IOException, ServerException {
        int token = this.nextToken();
        if (token != 4) {
            if (token == 2 && this.getWord().equals("error")) {
                throw new ServerException(this.readBlock());
            }
            throw new ProtocolException("Bug: Integer expected");
        }
        return this.getIntValue();
    }

    public void parseEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 1) {
            throw new ProtocolException("Bug: Dot expected");
        }
    }

    public void parsePartialEnd() throws ProtocolException, IOException {
        int token = this.nextToken();
        if (token != 8) {
            throw new ProtocolException("Bug: Semicolon expected");
        }
    }

    public SymbolicState parseSymbolicState(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] l = this.locationVector(system);
        Polyhedron z = this.zone(system);
        int[] v = this.variableVector(system);
        return new SymbolicState(l, v, z);
    }

    private SystemLocation[] locationVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        SystemLocation[] locations = new SystemLocation[system.getNoOfProcesses()];
        int i = 0;
        do {
            locations[i] = system.getLocation(i, this.parseInteger());
            ++i;
        } while (this.getLookahead() != 1);
        if (i != system.getNoOfProcesses()) {
            throw new ProtocolException("Invalid amount of locations. Expected " + system.getNoOfProcesses() + ", got " + i);
        }
        this.parseEnd();
        return locations;
    }

    private int[] variableVector(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int[] vector = new int[system.getNoOfVariables()];
        int i = 0;
        while (this.getLookahead() != 1) {
            vector[i++] = this.parseInteger();
        }
        this.parseEnd();
        return vector;
    }

    private Polyhedron zone(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        Polyhedron pol = new Polyhedron(system);
        while (this.getLookahead() != 1) {
            int i = this.parseInteger();
            int j = this.parseInteger();
            int b = this.parseInteger();
            pol.add(i, j, b ^ 1);
            this.parseEnd();
        }
        this.parseEnd();
        pol.trim();
        return pol;
    }

    private SystemEdgeSelect edgeCon(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        int i = this.parseInteger();
        int j = this.parseInteger();
        LinkedList<Integer> l = new LinkedList<Integer>();
        while (this.getLookahead() != 8) {
            l.add(this.parseInteger());
        }
        this.parsePartialEnd();
        return system.createEdgeCon(i, j, l);
    }

    public Problem problem() throws EngineException, IOException {
        String type = this.parseId();
        String path = this.readBlock();
        int fline = this.parseInteger();
        int fcolumn = this.parseInteger();
        int lline = this.parseInteger();
        int lcolumn = this.parseInteger();
        String msg = this.readBlock();
        String context = this.readBlock();
        return new Problem(type, path, fline, fcolumn, lline, lcolumn, msg, context);
    }

    public char parseQueryResult() throws EngineException, IOException {
        this.parseProlog();
        return this.parseId().charAt(0);
    }

    public SymbolicTrace parseXTRTrace(UppaalSystem system) throws ProtocolException {
        SymbolicTrace trace = new SymbolicTrace();
        try {
            SymbolicState src = this.parseSymbolicState(system);
            trace.add(new SymbolicTransition(null, null, src));
            while (this.getLookahead() != 1) {
                SymbolicState dst = this.parseSymbolicState(system);
                SystemEdgeSelect[] edges = this.edgesXTR(system);
                trace.add(new SymbolicTransition(src, edges, dst));
                src = dst;
            }
            this.parseEnd();
        }
        catch (ServerException | IOException e) {
            throw new ProtocolException(locale.getString("trace_mismatch"));
        }
        return trace;
    }

    private SystemEdgeSelect[] edgesXTR(UppaalSystem system) throws ProtocolException, IOException, ServerException {
        ArrayList<SystemEdgeSelect> edges = new ArrayList<SystemEdgeSelect>();
        do {
            edges.add(this.edgeCon(system));
        } while (this.getLookahead() != 1);
        this.parseEnd();
        SystemEdgeSelect[] se = new SystemEdgeSelect[edges.size()];
        return edges.toArray(se);
    }

    static {
        locale = ResourceBundle.getBundle("locale.Parser");
    }
}

