/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;

public class CrashSaver {
    public static final String ENGINE_CRASH_PREFIX = "enginecrash";

    public static Path getCrashDirectory() {
        Path p = Path.of(System.getProperty("user.home"), ".uppaal", "crashes");
        File dir = p.toFile();
        if (dir.exists() || !dir.mkdirs()) {
            // empty if block
        }
        return p;
    }

    public static void SaveCrash(String prefix, String trace) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        String currentTime = formatter.format(new Timestamp(System.currentTimeMillis()).toLocalDateTime());
        Object crashFile = "";
        int i = 0;
        while (true) {
            Object suffix = i == 0 ? "" : "-" + i;
            crashFile = prefix + "-" + currentTime + (String)suffix + ".txt";
            File file = CrashSaver.getCrashDirectory().resolve((String)crashFile).toFile();
            if (!file.exists()) break;
            ++i;
        }
        try {
            Files.writeString(CrashSaver.getCrashDirectory().resolve((String)crashFile).toAbsolutePath(), (CharSequence)trace, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

