/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.system.AbstractTransition;
import com.uppaal.model.system.GanttAddition;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteTransitionDelays;
import java.util.List;

public class ConcreteTraceElement
extends AbstractTransition {
    protected ConcreteState start;
    protected ConcreteState target;
    private final double delay;
    private DataSet2D trajectoryData;
    private ConcreteTransitionDelays[] transitions = new ConcreteTransitionDelays[0];
    private double maxDelay = -1.0;
    private double horizon = -1.0;
    private List<GanttAddition> ganttChart;

    public ConcreteTraceElement(double delay, SystemEdgeSelect[] edges, ConcreteState start, ConcreteState target) {
        super(edges);
        assert (start != target);
        this.target = target;
        this.start = start;
        this.delay = delay;
    }

    public ConcreteTraceElement(double delay, SystemEdgeSelect[] edges, ConcreteState start, ConcreteState target, ConcreteTransitionDelays[] transitions, List<GanttAddition> ganttChart, double maxDelay) {
        this(delay, edges, start, target);
        this.transitions = transitions;
        this.ganttChart = ganttChart;
        this.maxDelay = maxDelay;
    }

    public ConcreteState getStart() {
        return this.start;
    }

    @Override
    public ConcreteState getTarget() {
        return this.target;
    }

    public void setTarget(ConcreteState t) {
        this.target = t;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setTransitions(ConcreteTransitionDelays[] transitions) {
        this.transitions = transitions;
    }

    public void setMaxDelay(double maxDelay) {
        this.maxDelay = maxDelay;
    }

    public void setHorizon(double horizon) {
        this.horizon = horizon;
    }

    public double getHorizon() {
        return this.horizon;
    }

    public void setTrajectory(DataSet2D trajectory) {
        this.trajectoryData = trajectory;
    }

    public DataSet2D getTrajectory() {
        return this.trajectoryData;
    }

    public String traceFormat() {
        StringBuilder s = new StringBuilder("(");
        boolean start = true;
        for (SystemEdgeSelect edge : this.edges_ws) {
            if (start) {
                start = false;
            } else {
                s.append(", ");
            }
            s.append(edge.getFormatedName());
        }
        s.append(')');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcreteTraceElement)) {
            return false;
        }
        ConcreteTraceElement other = (ConcreteTraceElement)obj;
        if (this.getDelay() != other.getDelay()) {
            return false;
        }
        return this.getTarget().equals(other.getTarget());
    }

    public List<GanttAddition> getGanttChart() {
        return this.ganttChart;
    }

    public ConcreteTransitionDelays[] getTransitions() {
        return this.transitions;
    }

    public double getMaxDelay() {
        return this.maxDelay;
    }

    @Override
    public String getTransitionDescription() {
        if (this.hasEdges()) {
            return "Delay: " + this.getDelay() + "; " + super.getTransitionDescription();
        }
        return "Delay: " + this.getDelay();
    }

    public String toString() {
        return "(ConcreteTransitionRecord (" + this.target + ", " + this.edges_ws + ", " + this.delay + ")";
    }
}

