/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.util.export;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.freehep.graphicsbase.util.export.DigraphNode;

class PartialOrderIterator
implements Iterator {
    LinkedList zeroList = new LinkedList();
    Map inDegrees = new HashMap();

    public PartialOrderIterator(Iterator iter) {
        while (iter.hasNext()) {
            DigraphNode node = (DigraphNode)iter.next();
            int inDegree = node.getInDegree();
            this.inDegrees.put(node, new Integer(inDegree));
            if (inDegree != 0) continue;
            this.zeroList.add(node);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.zeroList.isEmpty();
    }

    public Object next() {
        DigraphNode first = (DigraphNode)this.zeroList.removeFirst();
        Iterator outNodes = first.getOutNodes();
        while (outNodes.hasNext()) {
            DigraphNode node = (DigraphNode)outNodes.next();
            int inDegree = (Integer)this.inDegrees.get(node) - 1;
            this.inDegrees.put(node, new Integer(inDegree));
            if (inDegree != 0) continue;
            this.zeroList.add(node);
        }
        return first.getData();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

