/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.syntax.jedit.EditActionMap;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.TextAreaPainter;
import org.syntax.jedit.TextUtilities;
import org.syntax.jedit.tokenmarker.Token;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class JEditTextArea
extends JComponent {
    public static String LEFT_OF_SCROLLBAR = "los";
    protected static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static JEditTextArea focusedComponent;
    protected static Timer caretTimer;
    protected TextAreaPainter painter;
    protected JPopupMenu popup;
    protected EventListenerList listenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;

    public JEditTextArea() {
        this(TextAreaDefaults.getDefaults());
    }

    public JEditTextArea(TextAreaDefaults defaults) {
        this(defaults, new EditActionMap());
    }

    public JEditTextArea(TextAreaDefaults defaults, ActionMap actions) {
        this.enableEvents(131072L);
        this.enableEvents(8L);
        this.setTransferHandler(new ClipboardHandler());
        this.painter = new TextAreaPainter(this, defaults);
        this.documentHandler = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.setActionMap(actions);
        this.installInputMap();
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this.painter);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addFocusListener(new FocusHandler());
        this.setDocument(defaults.document);
        this.editable = defaults.editable;
        this.caretVisible = defaults.caretVisible;
        this.caretBlinks = defaults.caretBlinks;
        this.electricScroll = defaults.electricScroll;
        this.popup = defaults.popup;
        focusedComponent = this;
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
    }

    private void installInputMap() {
        InputMap map = this.getInputMap();
        int shortcutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        int shortcutShiftModifier = shortcutModifier + 64;
        map.put(KeyStroke.getKeyStroke("BACK_SPACE"), "backspace");
        map.put(KeyStroke.getKeyStroke(8, shortcutModifier, true), "backspace-word");
        map.put(KeyStroke.getKeyStroke("DELETE"), "delete");
        map.put(KeyStroke.getKeyStroke(127, shortcutModifier, true), "delete-word");
        map.put(KeyStroke.getKeyStroke("ENTER"), "insert-break");
        map.put(KeyStroke.getKeyStroke("TAB"), "insert-tab");
        map.put(KeyStroke.getKeyStroke("shift TAB"), "remove-tab");
        map.put(KeyStroke.getKeyStroke("INSERT"), "overwrite");
        map.put(KeyStroke.getKeyStroke(92, shortcutModifier, true), "toogle-rect");
        map.put(KeyStroke.getKeyStroke("HOME"), "home");
        map.put(KeyStroke.getKeyStroke("END"), "end");
        map.put(KeyStroke.getKeyStroke(65, shortcutModifier, true), "select-all");
        map.put(KeyStroke.getKeyStroke("shift HOME"), "select-home");
        map.put(KeyStroke.getKeyStroke("shift END"), "select-end");
        map.put(KeyStroke.getKeyStroke(36, shortcutModifier, true), "document-home");
        map.put(KeyStroke.getKeyStroke(35, shortcutModifier, true), "document-end");
        map.put(KeyStroke.getKeyStroke(36, shortcutShiftModifier, true), "select-doc-home");
        map.put(KeyStroke.getKeyStroke(35, shortcutShiftModifier, true), "select-doc-end");
        map.put(KeyStroke.getKeyStroke("PAGE_UP"), "prev-page");
        map.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "next-page");
        map.put(KeyStroke.getKeyStroke("shift PAGE_UP"), "select-prev-page");
        map.put(KeyStroke.getKeyStroke("shift PAGE_DOWN"), "select-next-page");
        map.put(KeyStroke.getKeyStroke("LEFT"), "prev-char");
        map.put(KeyStroke.getKeyStroke("shift LEFT"), "select-prev-char");
        map.put(KeyStroke.getKeyStroke(37, shortcutModifier, true), "prev-word");
        map.put(KeyStroke.getKeyStroke(37, shortcutShiftModifier, true), "select-prev-word");
        map.put(KeyStroke.getKeyStroke("RIGHT"), "next-char");
        map.put(KeyStroke.getKeyStroke("shift RIGHT"), "select-next-char");
        map.put(KeyStroke.getKeyStroke(39, shortcutModifier, true), "next-word");
        map.put(KeyStroke.getKeyStroke(39, shortcutShiftModifier, true), "select-next-word");
        map.put(KeyStroke.getKeyStroke("UP"), "prev-line");
        map.put(KeyStroke.getKeyStroke("shift UP"), "select-prev-line");
        map.put(KeyStroke.getKeyStroke("DOWN"), "next-line");
        map.put(KeyStroke.getKeyStroke("shift DOWN"), "select-next-line");
        map.put(KeyStroke.getKeyStroke("shift DOWN"), "select-next-line");
        map.put(KeyStroke.getKeyStroke("alt UP"), "move-line-up");
        map.put(KeyStroke.getKeyStroke("alt DOWN"), "move-line-down");
        map.put(KeyStroke.getKeyStroke(67, shortcutModifier, true), "clipboard-copy");
        map.put(KeyStroke.getKeyStroke(86, shortcutModifier, true), "clipboard-paste");
        map.put(KeyStroke.getKeyStroke(88, shortcutModifier, true), "clipboard-cut");
        map.put(KeyStroke.getKeyStroke(32, shortcutModifier, true), "autocomplete");
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible = caretVisible;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        int width = this.painter.getWidth();
        if (this.horizontal != null && width != 0) {
            this.horizontal.setValues(-this.horizontalOffset, width, 0, width * 5);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(width / 2);
        }
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int firstLine) {
        if (firstLine == this.firstLine) {
            return;
        }
        int oldFirstLine = this.firstLine;
        this.firstLine = firstLine;
        if (firstLine != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        int oldVisibleLines = this.visibleLines;
        this.visibleLines = height / lineHeight;
        this.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        if (horizontalOffset != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public boolean setOrigin(int firstLine, int horizontalOffset) {
        boolean changed = false;
        int oldFirstLine = this.firstLine;
        if (horizontalOffset != this.horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            changed = true;
        }
        if (firstLine != this.firstLine) {
            this.firstLine = firstLine;
            changed = true;
        }
        if (changed) {
            this.updateScrollBars();
            this.painter.repaint();
        }
        return changed;
    }

    public boolean scrollToCaret() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = Math.max(0, Math.min(this.getLineLength(line) - 1, this.getCaretPosition() - lineStart));
        return this.scrollTo(line, offset);
    }

    public boolean scrollTo(int line, int offset) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, line - this.electricScroll));
            return true;
        }
        int newFirstLine = this.firstLine;
        int newHorizontalOffset = this.horizontalOffset;
        if (line < this.firstLine + this.electricScroll) {
            newFirstLine = Math.max(0, line - this.electricScroll);
        } else if (line + this.electricScroll >= this.firstLine + this.visibleLines) {
            newFirstLine = line - this.visibleLines + this.electricScroll + 1;
            if (newFirstLine + this.visibleLines >= this.getLineCount()) {
                newFirstLine = this.getLineCount() - this.visibleLines;
            }
            if (newFirstLine < 0) {
                newFirstLine = 0;
            }
        }
        int x = this._offsetToX(line, offset);
        int width = this.painter.getFontMetrics().charWidth('w');
        if (x < 0) {
            newHorizontalOffset = Math.min(0, this.horizontalOffset - x + width + 5);
        } else if (x + width >= this.painter.getWidth()) {
            newHorizontalOffset = this.horizontalOffset + (this.painter.getWidth() - x) - width - 5;
        }
        return this.setOrigin(newFirstLine, newHorizontalOffset);
    }

    public int lineToY(int line) {
        FontMetrics fm = this.painter.getFontMetrics();
        return (line - this.firstLine) * fm.getHeight() - (fm.getLeading() + fm.getMaxDescent());
    }

    public int yToLine(int y) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, y / height + this.firstLine));
    }

    public final int offsetToX(int line, int offset) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(line, offset);
    }

    public int _offsetToX(int line, int offset) {
        Token tokens;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        int segmentOffset = this.lineSegment.offset;
        int x = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = offset;
            return (int)((float)x + Utilities.getTabbedTextWidth(this.lineSegment, fm, (float)x, (TabExpander)this.painter, 0));
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        Toolkit toolkit = this.painter.getToolkit();
        Font defaultFont = this.painter.getFont();
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : this.getFontMetrics(styles[id].getStyledFont(defaultFont));
            int length = tokens.length;
            if (offset + segmentOffset < this.lineSegment.offset + length) {
                this.lineSegment.count = offset - (this.lineSegment.offset - segmentOffset);
                return (int)((float)x + Utilities.getTabbedTextWidth(this.lineSegment, fm, (float)x, (TabExpander)this.painter, 0));
            }
            this.lineSegment.count = length;
            x = (int)((float)x + Utilities.getTabbedTextWidth(this.lineSegment, fm, (float)x, (TabExpander)this.painter, 0));
            this.lineSegment.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public int xToOffset(int line, int x) {
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        if (tokenMarker != null) {
            Token tokens;
            if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
                tokens = this.painter.currentLineTokens;
            } else {
                this.painter.currentLineIndex = line;
                tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
            }
            SyntaxStyle[] styles = this.painter.getStyles();
            if (tokens.id == 127) {
                return 0;
            }
            if (tokens.id != 0) {
                fm = this.getFontMetrics(styles[tokens.id].getStyledFont(this.painter.getFont()));
            }
        }
        return Utilities.getTabbedTextOffset(this.lineSegment, fm, (float)this.horizontalOffset, (float)x, (TabExpander)this.painter, 0, true);
    }

    public int xyToOffset(int x, int y) {
        int line = this.yToLine(y);
        int start = this.getLineStartOffset(line);
        return start + this.xToOffset(line, x);
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.document.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineStartOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getStartOffset();
    }

    public int getLineEndOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset();
    }

    public int getLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public void setText(String text) {
        try {
            this.document.beginCompoundEdit();
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, text, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final String getText(int start, int len) {
        try {
            return this.document.getText(start, len);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public final void getText(int start, int len, Segment segment) {
        try {
            this.document.getText(start, len, segment);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int lineIndex) {
        int start = this.getLineStartOffset(lineIndex);
        return this.getText(start, this.getLineEndOffset(lineIndex) - start - 1);
    }

    public String getLinesText(int startLine, int endLine) {
        int start = this.getLineStartOffset(startLine);
        return this.getText(start, this.getLineEndOffset(endLine) - start - 1);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        int start = this.getLineStartOffset(lineIndex);
        this.getText(start, this.getLineEndOffset(lineIndex) - start - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int line) {
        if (line == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + start);
        }
        return this.getLineStartOffset(line);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int line) {
        if (line == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + end2);
        }
        return this.getLineEndOffset(line) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int caret) {
        this.select(caret, caret);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int start, int end2) {
        boolean newBias;
        int newEnd;
        int newStart;
        if (start <= end2) {
            newStart = start;
            newEnd = end2;
            newBias = false;
        } else {
            newStart = end2;
            newEnd = start;
            newBias = true;
        }
        if (newStart < 0 || newEnd > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + newStart + "," + newEnd);
        }
        if (newStart != this.selectionStart || newEnd != this.selectionEnd || newBias != this.biasLeft) {
            Clipboard systemSelection;
            int newStartLine = this.getLineOfOffset(newStart);
            int newEndLine = this.getLineOfOffset(newEnd);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(end2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(newStartLine, newEndLine);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = newStart;
            this.selectionEnd = newEnd;
            this.selectionStartLine = newStartLine;
            this.selectionEndLine = newEndLine;
            this.biasLeft = newBias;
            if (this.selectionStart != this.selectionEnd && (systemSelection = this.getToolkit().getSystemSelection()) != null) {
                systemSelection.setContents(new StringSelection(this.getSelectedText()), null);
            }
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            if (end2 < start) {
                int tmp = end2;
                end2 = start;
                start = tmp;
            }
            StringBuilder buf = new StringBuilder();
            Segment seg = new Segment();
            for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                int lineEnd = lineElement.getEndOffset() - 1;
                int lineLen = lineEnd - lineStart;
                lineStart = Math.min(lineStart + start, lineEnd);
                lineLen = Math.min(end2 - start, lineEnd - lineStart);
                this.getText(lineStart, lineLen, seg);
                buf.append(seg.array, seg.offset, seg.count);
                if (i == this.selectionEndLine) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public void replaceOnSelectedLines(String regex, String replacement) {
        int startOffset = this.getSelectionStart();
        int selectionSize = this.getSelectionEnd() - startOffset;
        int textStart = Math.max(this.getLineStartOffset(this.selectionStartLine) - 1, 0);
        int textEnd = Math.max(this.getLineEndOffset(this.selectionEndLine) - 1, 0);
        int length = startOffset - textStart;
        if (textStart == textEnd) {
            return;
        }
        Object selectedText = this.getText(textStart, textEnd - textStart);
        Object preSelectionText = this.getText(textStart, length);
        if (textStart == 0) {
            selectedText = "\n" + (String)selectedText;
            preSelectionText = "\n" + (String)preSelectionText;
        }
        int replacedLength = ((String)preSelectionText).replaceAll(regex, replacement).length();
        int preSelectionDifference = replacedLength - length;
        String newText = ((String)selectedText).replaceAll(regex, replacement);
        int lengthDifference = newText.length() - ((String)selectedText).length();
        if (textStart == 0) {
            newText = newText.substring(1);
            --preSelectionDifference;
        }
        this.setSelectionStart(textStart);
        this.setSelectionEnd(textEnd);
        this.setSelectedText(newText);
        if (lengthDifference != 0) {
            this.setSelectionStart(startOffset + preSelectionDifference);
            this.setSelectionEnd(startOffset + selectionSize + lengthDifference);
        } else {
            this.setSelectionStart(startOffset);
            this.setSelectionEnd(startOffset + selectionSize);
        }
    }

    public void setSelectedText(String selectedText) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        this.document.beginCompoundEdit();
        try {
            if (this.rectSelect) {
                Element map = this.document.getDefaultRootElement();
                int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
                int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
                if (end2 < start) {
                    int tmp = end2;
                    end2 = start;
                    start = tmp;
                }
                int lastNewline = 0;
                int currNewline = 0;
                for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                    Element lineElement = map.getElement(i);
                    int lineStart = lineElement.getStartOffset();
                    int lineEnd = lineElement.getEndOffset() - 1;
                    int rectStart = Math.min(lineEnd, lineStart + start);
                    this.document.remove(rectStart, Math.min(lineEnd - rectStart, end2 - start));
                    if (selectedText == null) continue;
                    currNewline = selectedText.indexOf(10, lastNewline);
                    if (currNewline == -1) {
                        currNewline = selectedText.length();
                    }
                    this.document.insertString(rectStart, selectedText.substring(lastNewline, currNewline), null);
                    lastNewline = Math.min(selectedText.length(), currNewline + 1);
                }
                if (selectedText != null && currNewline != selectedText.length()) {
                    int offset = map.getElement(this.selectionEndLine).getEndOffset() - 1;
                    this.document.insertString(offset, "\n", null);
                    this.document.insertString(offset + 1, selectedText.substring(currNewline + 1), null);
                }
            } else {
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (selectedText != null) {
                    this.document.insertString(this.selectionStart, selectedText, null);
                }
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.setCaretPosition(this.selectionEnd);
    }

    public void setText(int offset, int length, String newText) {
        if (offset < 0 || offset + length > this.document.getLength()) {
            throw new IndexOutOfBoundsException("Offset is not within document bounds");
        }
        this.document.beginCompoundEdit();
        try {
            this.document.remove(offset, length);
            this.document.insertString(offset, newText, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String str) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(str);
            return;
        }
        int caret = this.getCaretPosition();
        int caretLineEnd = this.getLineEndOffset(this.getCaretLine());
        if (caretLineEnd - caret <= str.length()) {
            this.setSelectedText(str);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            this.document.remove(caret, str.length());
            this.document.insertString(caret, str, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite2) {
        this.overwrite = overwrite2;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean rectSelect) {
        this.rectSelect = rectSelect;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public void pasteSelection() {
        Clipboard systemSelection = this.getToolkit().getSystemSelection();
        if (this.editable && systemSelection != null) {
            Transferable content = systemSelection.getContents(this);
            if (this.getTransferHandler().canImport(this, content.getTransferDataFlavors())) {
                this.getTransferHandler().importData(this, content);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400 && !evt.isConsumed()) {
            int modifiers = evt.getModifiersEx();
            char c = evt.getKeyChar();
            if (c != '\uffff' && ((modifiers & 0x280) == 0 || isMac) && (modifiers & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0 && c >= ' ' && c != '\u007f') {
                SwingUtilities.notifyAction(this.getActionMap().get("insert-char"), KeyStroke.getKeyStrokeForEvent(evt), evt, this, modifiers);
                evt.consume();
            }
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            int d = e.getUnitsToScroll();
            this.vertical.setValue(this.vertical.getValue() + d);
        }
    }

    protected void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
        }
    }

    protected void updateBracketHighlight(int newCaretPosition) {
        if (newCaretPosition == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int offset = TextUtilities.findMatchingBracket(this.document, newCaretPosition - 1);
            if (offset != -1) {
                this.bracketLine = this.getLineOfOffset(offset);
                this.bracketPosition = offset - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent evt) {
        DocumentEvent.ElementChange ch = evt.getChange(this.document.getDefaultRootElement());
        int count = ch == null ? 0 : ch.getChildrenAdded().length - ch.getChildrenRemoved().length;
        int line = this.getLineOfOffset(evt.getOffset());
        if (count == 0) {
            this.painter.invalidateLine(line);
        } else if (line < this.firstLine) {
            this.setFirstLine(this.firstLine + count);
        } else {
            this.painter.invalidateLineRange(line, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.painter.addMouseListener(listener);
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        CaretUndo(int start, int end2) {
            this.start = start;
            this.end = end2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof CaretUndo) {
                CaretUndo cedit = (CaretUndo)edit;
                this.start = cedit.start;
                this.end = cedit.end;
                cedit.die();
                return true;
            }
            return false;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
            if ((evt.getModifiersEx() & 0x1000) != 0 && JEditTextArea.this.popup != null) {
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, evt.getX(), evt.getY());
                return;
            }
            int line = JEditTextArea.this.yToLine(evt.getY());
            int offset = JEditTextArea.this.xToOffset(line, evt.getX());
            int dot = JEditTextArea.this.getLineStartOffset(line) + offset;
            switch (evt.getClickCount()) {
                case 1: {
                    this.doSingleClick(evt, line, offset, dot);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(evt, line, offset, dot);
                    }
                    catch (BadLocationException bl) {
                        bl.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(evt, line, offset, dot);
                }
            }
        }

        private void doSingleClick(MouseEvent evt, int line, int offset, int dot) {
            if ((evt.getModifiersEx() & 0x40) != 0) {
                JEditTextArea.this.rectSelect = (evt.getModifiersEx() & 0x80) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), dot);
            } else {
                JEditTextArea.this.setCaretPosition(dot);
                if ((evt.getModifiersEx() & 0x800) != 0) {
                    JEditTextArea.this.pasteSelection();
                }
            }
        }

        private void doDoubleClick(MouseEvent evt, int line, int offset, int dot) throws BadLocationException {
            if (JEditTextArea.this.getLineLength(line) == 0) {
                return;
            }
            try {
                int bracket = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, dot - 1));
                if (bracket != -1) {
                    int mark = JEditTextArea.this.getMarkPosition();
                    if (bracket > mark) {
                        ++bracket;
                        --mark;
                    }
                    JEditTextArea.this.select(mark, bracket);
                    return;
                }
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            String lineText = JEditTextArea.this.getLineText(line);
            char ch = lineText.charAt(Math.max(0, offset - 1));
            String noWordSep = (String)JEditTextArea.this.document.getProperty("noWordSep");
            if (noWordSep == null) {
                noWordSep = "";
            }
            boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
            int wordStart = 0;
            for (int i = offset - 1; i >= 0; --i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordStart = i + 1;
                break;
            }
            int wordEnd = lineText.length();
            for (int i = offset; i < lineText.length(); ++i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordEnd = i;
                break;
            }
            int lineStart = JEditTextArea.this.getLineStartOffset(line);
            JEditTextArea.this.select(lineStart + wordStart, lineStart + wordEnd);
        }

        private void doTripleClick(MouseEvent evt, int line, int offset, int dot) {
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(line), JEditTextArea.this.getLineEndOffset(line) - 1);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class DragHandler
    implements MouseMotionListener {
        DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            JEditTextArea.this.setSelectionRectangular((evt.getModifiers() & 2) != 0);
            JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(evt.getX(), evt.getY()));
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == offset ? JEditTextArea.this.selectionStart + length : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd >= offset ? JEditTextArea.this.selectionEnd + length : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset ? (JEditTextArea.this.selectionStart > offset + length ? JEditTextArea.this.selectionStart - length : offset) : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd > offset ? (JEditTextArea.this.selectionEnd > offset + length ? JEditTextArea.this.selectionEnd - length : offset) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent evt) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (evt.getAdjustable() == JEditTextArea.this.vertical) {
                        JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
                    } else {
                        JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
                    }
                }
            });
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        @Override
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    static class CaretBlinker
    extends AbstractAction {
        CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;
        private ArrayList<Component> leftOfScrollBar = new ArrayList();

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(CENTER)) {
                this.center = comp;
            } else if (name.equals(RIGHT)) {
                this.right = comp;
            } else if (name.equals(BOTTOM)) {
                this.bottom = comp;
            } else if (name.equals(LEFT_OF_SCROLLBAR)) {
                this.leftOfScrollBar.add(comp);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            }
            if (this.right == comp) {
                this.right = null;
            }
            if (this.bottom == comp) {
                this.bottom = null;
            } else {
                this.leftOfScrollBar.remove(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getPreferredSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getPreferredSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getPreferredSize();
            dim.height += bottomPref.height;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getMinimumSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getMinimumSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getMinimumSize();
            dim.height += bottomPref.height;
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int rightWidth = this.right.getPreferredSize().width;
            int bottomHeight = this.bottom.getPreferredSize().height;
            int centerWidth = size.width - rightWidth - ileft - iright;
            int centerHeight = size.height - bottomHeight - itop - ibottom;
            this.center.setBounds(ileft, itop, centerWidth, centerHeight);
            this.right.setBounds(ileft + centerWidth, itop, rightWidth, centerHeight);
            for (Component comp : this.leftOfScrollBar) {
                Dimension dim = comp.getPreferredSize();
                comp.setBounds(ileft, itop + centerHeight, dim.width, bottomHeight);
                ileft += dim.width;
            }
            this.bottom.setBounds(ileft, itop + centerHeight, size.width - rightWidth - ileft - iright, bottomHeight);
        }
    }

    class ClipboardHandler
    extends TransferHandler {
        ClipboardHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return JEditTextArea.this.editable ? 3 : 1;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            if ((this.getSourceActions(comp) & action) != 0) {
                StringSelection t = new StringSelection(this.getTextSelection());
                clip.setContents(t, null);
                this.exportDone(comp, t, action);
            }
        }

        private String getTextSelection() {
            if (JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd) {
                int line = JEditTextArea.this.getLineOfOffset(JEditTextArea.this.selectionStart);
                JEditTextArea.this.setSelectionStart(JEditTextArea.this.getLineStartOffset(line));
                JEditTextArea.this.setSelectionEnd(Math.min(JEditTextArea.this.getLineEndOffset(line), JEditTextArea.this.document.getLength()));
            }
            return JEditTextArea.this.getSelectedText();
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                JEditTextArea.this.setSelectedText("");
            }
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return Arrays.stream(transferFlavors).anyMatch(flavor -> flavor.match(DataFlavor.stringFlavor));
        }

        @Override
        public boolean importData(JComponent comp, Transferable content) {
            if (JEditTextArea.this.editable) {
                try {
                    this.paste(content);
                    return true;
                }
                catch (Exception e) {
                    JEditTextArea.this.getToolkit().beep();
                    return false;
                }
            }
            return false;
        }

        private void paste(Transferable content) throws UnsupportedFlavorException, IOException {
            String selection = ((String)content.getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
            JEditTextArea.this.setSelectedText(selection);
        }
    }
}

