#!/usr/bin/env ruby

# Map Short name -> [ codes ]

def sort_files(files)
  map = Hash.new
  all = []
  files.each { |f|
    type = `file #{f}`
    puts "#{f}: wrong encoding!" if !type["UTF-8"]
    name = f.chomp(".properties")
    code = name.gsub(/.*_/,"")
    code = "" if code == name
    if ! f.include? "___mac"
      name = name == "SwingEnglish" ? "Swing" : name.gsub("_"+code,"")
      all << code if code != "" && !all.include?(code)
      if map[name]
        map[name] << code
      else
        map[name] = [ code ]
      end
    end
  }
  [all,map]
end

def get_keys(filename)
  map = Hash.new
  skip = false
  File.open(filename, "r:UTF-8").each { |line|
    line.chomp!
    if skip
      skip = line.length > 0 && line[line.length-1] == '\\'
    elsif line != "" && line[0] != '#'
      skip = line[line.length-1] == '\\'
      key = line.gsub(/ *=.*/,"")
      if map[key]
        puts "#{filename}: duplicate #{key}"
      else
        map[key] = true
      end
    end
  }
  map
end

def check_files(pair)
  all = pair[0]
  map = pair[1]
  map.each { |name,codes|
    basename = name == "Swing" ? "SwingEnglish.properties" : (name + ".properties")
    all.each { |k| puts "#{name}_#{k}.properties is missing!" if !codes.include?(k) }
    base_keys = get_keys(basename)
    codes.each { |k|
      if k != ""
        code_keys = get_keys("#{name}_#{k}.properties")
        base_keys.each { |key,val| puts "#{name}_#{k}.properties: missing #{key}" if !code_keys[key] }
        code_keys.each { |key,val| puts "#{name}_#{k}.properties: deprecated #{key}" if !base_keys[key] }
      end
    }
  }
end

check_files(sort_files(Dir['*.properties']))
