/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.tokenmarker.Token;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    int currentLineIndex;
    Token currentLineTokens;
    Segment currentLine;
    protected JEditTextArea textArea;
    protected SyntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean paintInvalid;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected Highlight highlights;

    public TextAreaPainter(JEditTextArea textArea, TextAreaDefaults defaults) {
        this.textArea = textArea;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        final Font font = this.createFont(defaults);
        this.setFont(font);
        this.setForeground(UIManager.getColor("EditorPane.foreground"));
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TextAreaPainter.this.setFont(font);
            }
        });
        this.blockCaret = defaults.blockCaret;
        this.styles = defaults.styles;
        this.cols = defaults.cols;
        this.rows = defaults.rows;
        this.caretColor = defaults.caretColor;
        this.selectionColor = defaults.selectionColor;
        this.lineHighlightColor = defaults.lineHighlightColor;
        this.lineHighlight = defaults.lineHighlight;
        this.bracketHighlightColor = defaults.bracketHighlightColor;
        this.bracketHighlight = defaults.bracketHighlight;
        this.paintInvalid = defaults.paintInvalid;
        this.eolMarkerColor = defaults.eolMarkerColor;
        this.eolMarkers = defaults.eolMarkers;
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
    }

    private Font createFont(TextAreaDefaults defaults) {
        Font f = UIManager.getFont("TextField.font");
        Font font = new Font(defaults.fontFamily, 0, f.getSize());
        Map<TextAttribute, ?> attrs = font.getAttributes();
        attrs.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
        return font.deriveFont(attrs);
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] styles) {
        this.styles = styles;
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
        this.invalidateSelectedLines();
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.invalidateSelectedLines();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
        this.invalidateSelectedLines();
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.lineHighlight = lineHighlight;
        this.invalidateSelectedLines();
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final void setBracketHighlightColor(Color bracketHighlightColor) {
        this.bracketHighlightColor = bracketHighlightColor;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final void setBracketHighlightEnabled(boolean bracketHighlight) {
        this.bracketHighlight = bracketHighlight;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean blockCaret) {
        this.blockCaret = blockCaret;
        this.invalidateSelectedLines();
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color eolMarkerColor) {
        this.eolMarkerColor = eolMarkerColor;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean eolMarkers) {
        this.eolMarkers = eolMarkers;
        this.repaint();
    }

    public boolean getInvalidLinesPainted() {
        return this.paintInvalid;
    }

    public void setInvalidLinesPainted(boolean paintInvalid) {
        this.paintInvalid = paintInvalid;
    }

    public void addCustomHighlight(Highlight highlight) {
        highlight.init(this.textArea, this.highlights);
        this.highlights = highlight;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.highlights != null) {
            return this.highlights.getToolTipText(evt);
        }
        return null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gfx = (Graphics2D)g;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            gfx.addRenderingHints(map);
        }
        Integer tabSpaces = (Integer)this.textArea.getDocument().getProperty("tabSize");
        this.tabSize = this.fm.charWidth(' ') * tabSpaces;
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        int height = this.fm.getHeight();
        int firstLine = this.textArea.getFirstLine();
        int firstInvalid = firstLine + clipRect.y / height;
        int lastInvalid = firstLine + (clipRect.y + clipRect.height - 1) / height;
        try {
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            int x = this.textArea.getHorizontalOffset();
            for (int line = firstInvalid; line <= lastInvalid; ++line) {
                this.paintLine(gfx, tokenMarker, line, x);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                int h = clipRect.y + clipRect.height;
                this.repaint(0, h, this.getWidth(), this.getHeight() - h);
            }
        }
        catch (Exception e) {
            System.err.println("Error repainting line range {" + firstInvalid + "," + lastInvalid + "}:");
            e.printStackTrace();
        }
    }

    public final void invalidateLine(int line) {
        this.repaint(0, this.textArea.lineToY(line) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), this.fm.getHeight());
    }

    public final void invalidateLineRange(int firstLine, int lastLine) {
        this.repaint(0, this.textArea.lineToY(firstLine) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), (lastLine - firstLine + 1) * this.fm.getHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int offset = this.textArea.getHorizontalOffset();
        int ntabs = ((int)x - offset) / this.tabSize;
        return (ntabs + 1) * this.tabSize + offset;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        dim.width = this.fm.charWidth('w') * this.cols;
        dim.height = this.fm.getHeight() * this.rows;
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 50);
    }

    protected void paintLine(Graphics2D gfx, TokenMarker tokenMarker, int line, int x) {
        Font defaultFont = this.getFont();
        Color defaultColor = this.getForeground();
        this.currentLineIndex = line;
        int y = this.textArea.lineToY(line);
        if (line < 0 || line >= this.textArea.getLineCount()) {
            if (this.paintInvalid) {
                this.paintHighlight(gfx, line, y);
                this.styles[10].setGraphicsFlags(gfx, defaultFont);
                gfx.drawString("~", 0, y + this.fm.getHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(gfx, line, defaultFont, defaultColor, x, y);
        } else {
            this.paintSyntaxLine(gfx, tokenMarker, line, defaultFont, defaultColor, x, y);
        }
    }

    protected void paintPlainLine(Graphics2D gfx, int line, Font defaultFont, Color defaultColor, float x, float y) {
        this.paintHighlight(gfx, line, y);
        this.textArea.getLineText(line, this.currentLine);
        gfx.setFont(defaultFont);
        gfx.setColor(defaultColor);
        x = Utilities.drawTabbedText(this.currentLine, x, y += (float)this.fm.getHeight(), gfx, (TabExpander)this, 0);
        if (this.eolMarkers) {
            gfx.setColor(this.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintSyntaxLine(Graphics2D gfx, TokenMarker tokenMarker, int line, Font defaultFont, Color defaultColor, int x, int y) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(gfx, line, y);
        gfx.setFont(defaultFont);
        gfx.setColor(defaultColor);
        x = SyntaxUtilities.paintSyntaxLine(this.currentLine, this.currentLineTokens, this.styles, this, gfx, x, y += this.fm.getHeight());
        if (this.eolMarkers) {
            gfx.setColor(this.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintHighlight(Graphics2D gfx, int line, float y) {
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(gfx, line, y);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(gfx, line, y);
        }
        if (this.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(gfx, line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(gfx, line, y);
        }
    }

    protected void paintLineHighlight(Graphics2D gfx, int line, float y) {
        int selectionEnd;
        int height = this.fm.getHeight();
        y += (float)(this.fm.getLeading() + this.fm.getMaxDescent());
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart == (selectionEnd = this.textArea.getSelectionEnd())) {
            if (this.lineHighlight) {
                gfx.setColor(this.lineHighlightColor);
                gfx.fillRect(0, (int)y, this.getWidth(), height);
            }
        } else {
            int x2;
            int x1;
            gfx.setColor(this.selectionColor);
            int selectionStartLine = this.textArea.getSelectionStartLine();
            int selectionEndLine = this.textArea.getSelectionEndLine();
            int lineStart = this.textArea.getLineStartOffset(line);
            if (this.textArea.isSelectionRectangular()) {
                int lineLen = this.textArea.getLineLength(line);
                x1 = this.textArea._offsetToX(line, Math.min(lineLen, selectionStart - this.textArea.getLineStartOffset(selectionStartLine)));
                if (x1 == (x2 = this.textArea._offsetToX(line, Math.min(lineLen, selectionEnd - this.textArea.getLineStartOffset(selectionEndLine))))) {
                    ++x2;
                }
            } else if (selectionStartLine == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else if (line == selectionStartLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.getWidth();
            } else if (line == selectionEndLine) {
                x1 = 0;
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else {
                x1 = 0;
                x2 = this.getWidth();
            }
            gfx.fillRect(x1 > x2 ? x2 : x1, (int)y, x1 > x2 ? x1 - x2 : x2 - x1, height);
        }
    }

    protected void paintBracketHighlight(Graphics2D gfx, int line, float y) {
        int position = this.textArea.getBracketPosition();
        if (position == -1) {
            return;
        }
        int x = this.textArea._offsetToX(line, position);
        gfx.setColor(this.bracketHighlightColor);
        gfx.drawRect(x, (int)(y += (float)(this.fm.getLeading() + this.fm.getMaxDescent())), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintCaret(Graphics2D gfx, int line, float y) {
        if (this.textArea.isCaretVisible()) {
            int offset = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
            int caretX = this.textArea._offsetToX(line, offset);
            int caretWidth = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 2;
            y += (float)(this.fm.getLeading() + this.fm.getMaxDescent());
            int height = this.fm.getHeight();
            gfx.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                gfx.fillRect(caretX, (int)y + height - 2, caretWidth, 2);
            } else {
                gfx.fillRect(caretX, (int)y, caretWidth, height);
            }
        }
    }

    public static interface Highlight {
        public void init(JEditTextArea var1, Highlight var2);

        public void paintHighlight(Graphics2D var1, int var2, float var3);

        public String getToolTipText(MouseEvent var1);
    }
}

