/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import javax.swing.text.Segment;
import org.syntax.jedit.SyntaxUtilities;

public class KeywordMap {
    protected int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;

    public KeywordMap(boolean ignoreCase) {
        this(ignoreCase, 52);
        this.ignoreCase = ignoreCase;
    }

    public KeywordMap(boolean ignoreCase, int mapLength) {
        this.mapLength = mapLength;
        this.ignoreCase = ignoreCase;
        this.map = new Keyword[mapLength];
    }

    public byte lookup(Segment text, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.map[this.getSegmentMapKey(text, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, text, offset, k.keyword) && k.inRange(offset)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword, byte id) {
        int key = this.getStringMapKey(keyword);
        this.map[key] = new Keyword(keyword.toCharArray(), id, this.map[key]);
    }

    public void add(String keyword, byte id, int start, int end2) {
        int key = this.getStringMapKey(keyword);
        this.map[key] = new Keyword(keyword.toCharArray(), id, this.map[key], start, end2);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    protected int getStringMapKey(String s) {
        return (Character.toUpperCase(s.charAt(0)) + Character.toUpperCase(s.charAt(s.length() - 1))) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
    }

    private static class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;
        public int start;
        public int end;

        public Keyword(char[] keyword, byte id, Keyword next) {
            this(keyword, id, next, 0, Integer.MAX_VALUE);
        }

        public Keyword(char[] keyword, byte id, Keyword next, int start, int end2) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
            this.start = start;
            this.end = end2;
        }

        public boolean inRange(int off) {
            return off >= this.start && off <= this.end;
        }
    }
}

