/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.util.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.freehep.graphicsbase.util.export.FilterIterator;
import org.freehep.graphicsbase.util.export.SubRegistry;

public class ServiceRegistry {
    private Map categoryMap = new HashMap();

    public ServiceRegistry(Iterator<Class<?>> categories) {
        if (categories == null) {
            throw new IllegalArgumentException("categories == null!");
        }
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            SubRegistry reg = new SubRegistry(this, category);
            this.categoryMap.put(category, reg);
        }
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass, ClassLoader loader) {
        if (providerClass == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return ServiceLoader.load(providerClass, loader).iterator();
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return ServiceLoader.load(providerClass).iterator();
    }

    public Iterator<Class<?>> getCategories() {
        Set keySet = this.categoryMap.keySet();
        return keySet.iterator();
    }

    private Iterator getSubRegistries(Object provider) {
        ArrayList<SubRegistry> l = new ArrayList<SubRegistry>();
        for (Class c : this.categoryMap.keySet()) {
            if (!c.isAssignableFrom(provider.getClass())) continue;
            l.add((SubRegistry)this.categoryMap.get(c));
        }
        return l.iterator();
    }

    public <T> boolean registerServiceProvider(T provider, Class<T> category) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!category.isAssignableFrom(provider.getClass())) {
            throw new ClassCastException();
        }
        return reg.registerServiceProvider(provider);
    }

    public void registerServiceProvider(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator regs = this.getSubRegistries(provider);
        while (regs.hasNext()) {
            SubRegistry reg = (SubRegistry)regs.next();
            reg.registerServiceProvider(provider);
        }
    }

    public void registerServiceProviders(Iterator<?> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        while (providers.hasNext()) {
            this.registerServiceProvider(providers.next());
        }
    }

    public <T> boolean deregisterServiceProvider(T provider, Class<T> category) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!category.isAssignableFrom(provider.getClass())) {
            throw new ClassCastException();
        }
        return reg.deregisterServiceProvider(provider);
    }

    public void deregisterServiceProvider(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator regs = this.getSubRegistries(provider);
        while (regs.hasNext()) {
            SubRegistry reg = (SubRegistry)regs.next();
            reg.deregisterServiceProvider(provider);
        }
    }

    public boolean contains(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator regs = this.getSubRegistries(provider);
        while (regs.hasNext()) {
            SubRegistry reg = (SubRegistry)regs.next();
            if (!reg.contains(provider)) continue;
            return true;
        }
        return false;
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, boolean useOrdering) {
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        return reg.getServiceProviders(useOrdering);
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, Filter filter, boolean useOrdering) {
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        Iterator<T> iter = this.getServiceProviders(category, useOrdering);
        return new FilterIterator<T>(iter, filter);
    }

    public <T> T getServiceProviderByClass(Class<T> providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        for (Class c : this.categoryMap.keySet()) {
            SubRegistry reg;
            T provider;
            if (!c.isAssignableFrom(providerClass) || (provider = (reg = (SubRegistry)this.categoryMap.get(c)).getServiceProviderByClass(providerClass)) == null) continue;
            return provider;
        }
        return null;
    }

    public <T> boolean setOrdering(Class<T> category, T firstProvider, T secondProvider) {
        if (firstProvider == null || secondProvider == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (firstProvider == secondProvider) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (reg.contains(firstProvider) && reg.contains(secondProvider)) {
            return reg.setOrdering(firstProvider, secondProvider);
        }
        return false;
    }

    public <T> boolean unsetOrdering(Class<T> category, T firstProvider, T secondProvider) {
        if (firstProvider == null || secondProvider == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (firstProvider == secondProvider) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (reg.contains(firstProvider) && reg.contains(secondProvider)) {
            return reg.unsetOrdering(firstProvider, secondProvider);
        }
        return false;
    }

    public void deregisterAll(Class<?> category) {
        SubRegistry reg = (SubRegistry)this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        reg.clear();
    }

    public void deregisterAll() {
        for (SubRegistry reg : this.categoryMap.values()) {
            reg.clear();
        }
    }

    public void finalize() throws Throwable {
        this.deregisterAll();
        super.finalize();
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

