/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.engine.protocol.viewmodel.ParameterReferenceViewModel;
import com.uppaal.model.Translator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class IdentifierTranslator
implements Translator {
    private Map<String, String> map;
    private final String delim = "\t\n\r\f,.<>&|!+-*/%?:;=()/{}[]^ ";

    public IdentifierTranslator(Map<String, String> map) {
        this.map = map;
    }

    public IdentifierTranslator(List<ParameterReferenceViewModel> bindings) {
        this.map = new HashMap<String, String>();
        for (ParameterReferenceViewModel binding : bindings) {
            this.map.put(binding.getFormalParameter(), binding.getArgument());
        }
    }

    @Override
    public String translate(String content) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(content, "\t\n\r\f,.<>&|!+-*/%?:;=()/{}[]^ ", true);
        boolean lastWasDotOperator = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String value = this.map.get(token);
            if (value == null || lastWasDotOperator) {
                result.append(token);
                lastWasDotOperator = ".".equals(token);
                continue;
            }
            result.append(value);
        }
        return result.toString();
    }
}

