/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractLocation;
import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Data2D;
import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EngineSettings;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryExpected;
import com.uppaal.model.core2.QueryResource;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.core2.QueryValue;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.LscElement;
import com.uppaal.model.core2.lsc.LscTemplate;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import com.uppaal.model.io2.UXMLResolver;
import java.awt.Color;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWriter
extends AbstractVisitor {
    protected int counter;
    protected XMLStreamWriter writer;
    protected Map<AbstractLocation, String> locations = new HashMap<AbstractLocation, String>();
    protected Map<InstanceLine, String> instances = new HashMap<InstanceLine, String>();
    private ArrayList<Integer> yLocCoord = new ArrayList();
    protected String init;
    int depth = 0;

    public XMLWriter(OutputStream stream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(stream, StandardCharsets.UTF_8.name());
    }

    public XMLWriter(Writer writer) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(writer);
    }

    protected void indent() throws XMLStreamException {
        this.writer.writeCharacters("\r\n");
        for (int i = 0; i < this.depth; ++i) {
            this.writer.writeCharacters("\t");
        }
    }

    protected void writePropertyAsElement(Element element, String property, boolean optional) throws XMLStreamException {
        String value = (String)element.getPropertyValue(property);
        if (!optional || value != null && value.length() > 0) {
            this.indent();
            this.writer.writeStartElement(property);
            this.writeAttributes(element.getProperty(property));
            if (value != null) {
                this.writer.writeCharacters(value);
            }
            this.writer.writeEndElement();
        }
    }

    protected void writePropertyAsLabel(Element element, String name) throws XMLStreamException {
        String str;
        Property property = element.getProperty(name);
        if (property != null && (str = property.getValue().toString().trim()).length() > 0) {
            this.indent();
            this.writer.writeStartElement("label");
            this.writer.writeAttribute("kind", name);
            this.writeAttributes(property);
            this.writer.writeCharacters(str);
            this.writer.writeEndElement();
        }
    }

    protected void writeAttributes(Element element) throws XMLStreamException {
        Property color;
        Object x = element.getPropertyValue("x");
        Object y = element.getPropertyValue("y");
        if (element.getParent() instanceof Message) {
            Float f = (Float)element.getPropertyValue("f");
            Message message = (Message)element.getParent();
            int s = message.getSource().getX();
            int t = message.getTarget().getX();
            x = (int)((float)s + f.floatValue() * (float)(t - s));
        }
        if (x != null) {
            this.writer.writeAttribute("x", x.toString());
        }
        if (y != null) {
            this.writer.writeAttribute("y", y.toString());
        }
        if ((color = element.getLocalProperty("color")) != null) {
            int rgb = ((Color)color.getValue()).getRGB() & 0xFFFFFF;
            String hex = String.format("#%06x", rgb);
            this.writer.writeAttribute("color", hex);
        }
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected void writeFlag(Element element, String property) throws XMLStreamException {
        if (this.hasFlag(element, property)) {
            this.indent();
            this.writer.writeEmptyElement(property);
        }
    }

    protected void writeTextField(String localName, String contents) throws XMLStreamException {
        if (contents.trim().isEmpty()) {
            this.writer.writeEmptyElement(localName);
        } else {
            this.writer.writeStartElement(localName);
            this.writer.writeCharacters(contents);
            this.writer.writeEndElement();
        }
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        this.writer.writeStartDocument("utf-8", "1.0");
        this.indent();
        this.writer.writeDTD("<!DOCTYPE nta PUBLIC '" + UXMLResolver.getPublicID() + "' '" + UXMLResolver.getSystemID() + "'>");
        this.indent();
        this.writer.writeStartElement("nta");
        ++this.depth;
        this.writePropertyAsElement(document, "declaration", true);
        for (AbstractTemplate template : document.getTemplateList()) {
            this.visitTemplate(template);
        }
        this.writePropertyAsElement(document, "instantiation", true);
        this.writePropertyAsElement(document, "system", false);
        this.visitConcretePlotConfigs(document.getConcretePlots());
        document.getQueryList().accept(this);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
        this.indent();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    @Override
    public void visitTemplate(AbstractTemplate template) throws Exception {
        if (template instanceof Template) {
            this.visitTemplate((Template)template);
        } else {
            this.visitTemplate((LscTemplate)template);
        }
    }

    private void visitTemplate(Template template) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("template");
        this.writePropertyAsElement(template, "name", false);
        this.writePropertyAsElement(template, "parameter", true);
        this.writePropertyAsElement(template, "declaration", true);
        template.accept(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) throws Exception {
                location.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
                branchPoint.accept(XMLWriter.this);
            }
        });
        if (this.init != null) {
            this.indent();
            this.writer.writeEmptyElement("init");
            this.writer.writeAttribute("ref", this.init);
            this.init = null;
        }
        template.accept(new AbstractVisitor(){

            @Override
            public void visitEdge(Edge edge) throws Exception {
                edge.accept(XMLWriter.this);
            }
        });
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void visitTemplate(LscTemplate template) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("lsc");
        this.writePropertyAsElement(template, "name", false);
        this.writePropertyAsElement(template, "parameter", true);
        this.writePropertyAsElement(template, "type", false);
        this.writePropertyAsElement(template, "mode", false);
        this.writePropertyAsElement(template, "declaration", true);
        this.yLocCoord = template.getYLocCoord();
        int size = this.yLocCoord.size();
        for (int i = 0; i < size; ++i) {
            this.indent();
            this.writer.writeEmptyElement("yloccoord");
            this.writer.writeAttribute("number", String.valueOf(i));
            this.writer.writeAttribute("y", this.yLocCoord.get(i).toString());
        }
        template.accept(new AbstractVisitor(){

            @Override
            public void visitInstanceLine(InstanceLine instance) throws Exception {
                instance.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitPrechart(Prechart prechart) throws Exception {
                prechart.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitMessage(Message message) throws Exception {
                message.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitCondition(Condition condition) throws Exception {
                condition.accept(XMLWriter.this);
            }
        });
        template.accept(new AbstractVisitor(){

            @Override
            public void visitUpdate(Update update) throws Exception {
                update.accept(XMLWriter.this);
            }
        });
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("location");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(location);
        this.locations.put(location, id);
        this.writePropertyAsElement(location, "name", true);
        this.writePropertyAsLabel(location, "invariant");
        this.writePropertyAsLabel(location, "exponentialrate");
        this.writePropertyAsLabel(location, "comments");
        this.writePropertyAsLabel(location, "testcodeEnter");
        this.writePropertyAsLabel(location, "testcodeExit");
        this.writeFlag(location, "urgent");
        this.writeFlag(location, "committed");
        if (this.hasFlag(location, "init")) {
            this.init = id;
        }
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        this.writer.writeEmptyElement("branchpoint");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(branchPoint);
        this.locations.put(branchPoint, id);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("transition");
        this.writer.writeAttribute("id", id);
        if (!edge.hasFlag("controllable")) {
            this.writer.writeAttribute("controllable", "false");
        }
        this.writeAttributes(edge);
        this.indent();
        this.writer.writeEmptyElement("source");
        this.writer.writeAttribute("ref", this.locations.get(edge.getSource()));
        this.indent();
        this.writer.writeEmptyElement("target");
        this.writer.writeAttribute("ref", this.locations.get(edge.getTarget()));
        this.writePropertyAsLabel(edge, "select");
        this.writePropertyAsLabel(edge, "guard");
        this.writePropertyAsLabel(edge, "synchronisation");
        this.writePropertyAsLabel(edge, "assignment");
        this.writePropertyAsLabel(edge, "comments");
        this.writePropertyAsLabel(edge, "testcode");
        this.writePropertyAsLabel(edge, "probability");
        super.visitEdge(edge);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.indent();
        this.writer.writeEmptyElement("nail");
        this.writeAttributes(nail);
    }

    @Override
    public void visitInstanceLine(InstanceLine instance) throws Exception {
        String id = "id" + this.counter++;
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("instance");
        this.writer.writeAttribute("id", id);
        this.writeAttributes(instance);
        this.instances.put(instance, id);
        this.writePropertyAsElement(instance, "name", true);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitPrechart(Prechart prechart) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("prechart");
        this.writeAttributes(prechart);
        this.location(prechart);
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void location(LscElement element) throws Exception {
        Integer value = this.yLocCoord.indexOf(element.getY());
        this.indent();
        this.writer.writeStartElement("lsclocation");
        this.writer.writeCharacters(value.toString());
        this.writer.writeEndElement();
    }

    @Override
    public void visitMessage(Message message) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("message");
        this.writeAttributes(message);
        this.indent();
        this.writer.writeEmptyElement("source");
        this.writer.writeAttribute("ref", this.instances.get(message.getSource()));
        this.indent();
        this.writer.writeEmptyElement("target");
        this.writer.writeAttribute("ref", this.instances.get(message.getTarget()));
        this.location(message);
        this.writePropertyAsLabel(message, "message");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitCondition(Condition condition) throws Exception {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement("condition");
        this.writeAttributes(condition);
        ArrayList<InstanceLine> anchors = condition.getAnchors();
        for (InstanceLine anchor : anchors) {
            this.indent();
            this.writer.writeEmptyElement("anchor");
            this.writer.writeAttribute("instanceid", this.instances.get(anchor));
        }
        this.location(condition);
        this.temperature(condition);
        this.writePropertyAsLabel(condition, "condition");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void temperature(Condition condition) throws Exception {
        boolean value = (Boolean)condition.getPropertyValue("hot");
        String temperature = value ? "hot" : "cold";
        this.indent();
        this.writer.writeStartElement("temperature");
        this.writer.writeCharacters(temperature);
        this.writer.writeEndElement();
    }

    @Override
    public void visitUpdate(Update update) throws Exception {
        this.indent();
        this.writer.writeStartElement("update");
        this.writeAttributes(update);
        if (update.getAnchoredToCondition() != null) {
            Integer y = update.getAnchoredToCondition().getY();
            update.setProperty("y", y);
        }
        ++this.depth;
        this.indent();
        this.writer.writeEmptyElement("anchor");
        this.writer.writeAttribute("instanceid", this.instances.get(update.getAnchor()));
        this.location(update);
        this.writePropertyAsLabel(update, "update");
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitQuery(Query query) throws Exception {
        this.indent();
        this.writer.writeStartElement("query");
        ++this.depth;
        this.indent();
        this.writeTextField("formula", query.getFormula());
        this.indent();
        this.writeTextField("comment", query.getComment());
        if (query.getSettings() != null) {
            this.visitSettings(query.getSettings());
        }
        if (query.getExpected() != null && query.getExpected().getValue() != null) {
            this.visitExpect(query.getExpected());
        }
        if (query.getResult().getStatus() != QueryValue.Status.Unchecked) {
            this.visitResults(query.getResult());
        }
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitSettings(EngineSettings settings) throws Exception {
        if (settings == null) {
            return;
        }
        for (Map.Entry<String, Property> setting : settings.getProperties().entrySet()) {
            this.indent();
            this.writer.writeEmptyElement("option");
            this.writer.writeAttribute("key", setting.getKey());
            this.writer.writeAttribute("value", (String)setting.getValue().getValue());
        }
    }

    @Override
    public void visitResults(QueryResult result) throws Exception {
        this.indent();
        this.writer.writeStartElement("result");
        this.visitQueryValue(result.getValue());
        this.writer.writeAttribute("timestamp", result.getTimestamp());
        ++this.depth;
        if (result.getSettings() != null) {
            this.visitSettings(result.getSettings());
        }
        if (result.getMessage() != null && !result.getMessage().isEmpty()) {
            this.indent();
            this.writeTextField("details", result.getMessage());
        }
        for (DataSet2D plotData : result.getPlots()) {
            this.visitPlot(plotData);
        }
        this.visitResourceList(result.getResources());
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    private void visitPlot(DataSet2D plot) throws Exception {
        this.indent();
        this.writer.writeStartElement("plot");
        this.writer.writeAttribute("title", plot.getTitle());
        this.writer.writeAttribute("xaxis", plot.getXLabel());
        this.writer.writeAttribute("yaxis", plot.getYLabel());
        ++this.depth;
        for (Data2D series : plot) {
            this.indent();
            this.writer.writeStartElement("series");
            this.writer.writeAttribute("title", series.getTitle());
            this.writer.writeAttribute("type", series.getType());
            this.writer.writeAttribute("color", "0x" + Integer.toHexString(series.getColor().getRGB()).substring(2));
            this.writer.writeAttribute("encoding", "csv");
            StringBuilder sb = new StringBuilder();
            series.forEach(point -> sb.append(point.x).append(',').append(point.y).append('\n'));
            this.writer.writeCharacters(sb.toString().trim());
            this.indent();
            this.writer.writeEndElement();
        }
        StringBuilder sb = new StringBuilder();
        for (String comment : plot.getComments()) {
            sb.append(comment).append('\n');
        }
        this.indent();
        this.writeTextField("comment", sb.substring(0, sb.length() - 1));
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitExpect(QueryExpected expect) throws Exception {
        if (expect.getValue() == null) {
            return;
        }
        this.indent();
        this.writer.writeStartElement("expect");
        ++this.depth;
        this.visitQueryValue(expect.getValue());
        this.visitResourceList(expect.getResources());
        --this.depth;
        this.indent();
        this.writer.writeEndElement();
    }

    @Override
    public void visitResourceList(List<QueryResource> resources) throws Exception {
        for (QueryResource resource : resources) {
            this.indent();
            this.writer.writeEmptyElement("resource");
            this.writer.writeAttribute("type", resource.type);
            this.writer.writeAttribute("value", resource.value);
            if (resource.unit == null || resource.unit.trim().isEmpty()) continue;
            this.writer.writeAttribute("unit", resource.unit);
        }
    }

    @Override
    public void visitQueryValue(QueryValue value) throws Exception {
        this.writer.writeAttribute("outcome", value.getStatus().toString().toLowerCase());
        this.writer.writeAttribute("type", value.getKind().toString().toLowerCase());
        if (value.getValue() != null && !value.getValue().trim().isEmpty()) {
            this.writer.writeAttribute("value", value.getValue().trim());
        }
    }
}

