/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.io2.Problem;
import com.uppaal.model.io2.XMLReader;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.stream.XMLResolver;

public class UXMLResolver
implements XMLResolver {
    private static final String UNKNOWN_XML = XMLReader.LOCALE.getString("unknown_xml");
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 6;
    private static final String PUBLIC_PREFIX = "-//Uppaal Team//DTD Flat System ";
    private static final String PUBLIC_ID = "-//Uppaal Team//DTD Flat System 1.6//EN";
    private static final String SYSTEM_PREFIX = "http://www.it.uu.se/research/group/darts/uppaal/flat-";
    private static final String SYSTEM_ID = "http://www.it.uu.se/research/group/darts/uppaal/flat-1_6.dtd";
    private static final String DTD_PREFIX = "com/uppaal/resource/flat-";
    private static final String DTD = "com/uppaal/resource/flat-1_6.dtd";
    private static final URL DTD_RES = ClassLoader.getSystemResource("com/uppaal/resource/flat-1_6.dtd");
    private static final String PUBLIC_ID34 = "-//Uppaal Team//DTD Flat System 1.0//EN";
    private static final String SYSTEM_ID34 = "http://www.docs.uu.se/docs/rtmv/uppaal/xml/flat-1_0.dtd";
    private static final URL DTD34 = ClassLoader.getSystemResource("com/uppaal/resource/uppaal-3.4.dtd");
    private final List<Problem> problems;

    public UXMLResolver(List<Problem> problems) {
        this.problems = problems;
    }

    public static String getPublicID() {
        return PUBLIC_ID.replace('\"', '\'');
    }

    public static String getSystemID() {
        return SYSTEM_ID.replace('\"', '\'');
    }

    public static boolean publicIDMatch(String publicid) {
        if (!publicid.startsWith(PUBLIC_PREFIX)) {
            return false;
        }
        int dot = publicid.indexOf(46, PUBLIC_PREFIX.length());
        if (dot < 0) {
            return false;
        }
        int major_version = Integer.valueOf(publicid.substring(PUBLIC_PREFIX.length(), dot));
        int slash = publicid.indexOf(47, dot + 1);
        if (slash < 0) {
            return false;
        }
        int minor_version = Integer.valueOf(publicid.substring(dot + 1, slash));
        if (major_version > 1) {
            return false;
        }
        return minor_version <= 6;
    }

    public static boolean systemIDMatch(String systemid) {
        if (!systemid.startsWith(SYSTEM_PREFIX)) {
            return false;
        }
        int dot = systemid.indexOf(95, SYSTEM_PREFIX.length());
        if (dot < 0) {
            return false;
        }
        int major_version = Integer.valueOf(systemid.substring(SYSTEM_PREFIX.length(), dot));
        int slash = systemid.indexOf(46, dot + 1);
        if (slash < 0) {
            return false;
        }
        int minor_version = Integer.valueOf(systemid.substring(dot + 1, slash));
        if (major_version > 1) {
            return false;
        }
        return minor_version <= 6;
    }

    @Override
    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
        if (PUBLIC_ID34.equals(publicID) && SYSTEM_ID34.equals(systemID)) {
            try {
                return DTD34.openStream();
            }
            catch (IOException e) {
                System.err.println("Warning: Local DTD not found");
            }
        }
        if (!UXMLResolver.publicIDMatch(publicID)) {
            this.problems.add(new Problem("WARNING", "/!DOCTYPE/PUBLIC", UNKNOWN_XML + " " + publicID));
        }
        if (!UXMLResolver.systemIDMatch(systemID)) {
            this.problems.add(new Problem("WARNING", "/!DOCTYPE/SYSTEM", UNKNOWN_XML + " " + systemID));
        }
        try {
            return DTD_RES.openStream();
        }
        catch (IOException e) {
            System.err.println("Warning: Local DTD not found");
            return null;
        }
    }
}

