/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EngineSettings;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.PlotConfiguration;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryExpected;
import com.uppaal.model.core2.QueryList;
import com.uppaal.model.core2.QueryResource;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.core2.QueryValue;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.core2.lsc.Condition;
import com.uppaal.model.core2.lsc.Cut;
import com.uppaal.model.core2.lsc.InstanceLine;
import com.uppaal.model.core2.lsc.Message;
import com.uppaal.model.core2.lsc.Prechart;
import com.uppaal.model.core2.lsc.Update;
import java.util.ArrayList;
import java.util.List;

public class XPathBuilder
implements Visitor {
    ArrayList<String> result = new ArrayList();

    public String getXPath(Element e) {
        this.result.clear();
        try {
            e.accept(this);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        StringBuffer s = new StringBuffer();
        for (int i = this.result.size() - 1; i >= 0; --i) {
            s.append(this.result.get(i));
        }
        return s.toString();
    }

    @Override
    public void visitElement(Element element) throws Exception {
        this.result.add("/");
        Element parent = element.getParent();
        if (parent != null) {
            parent.accept(this);
        }
    }

    @Override
    public void visitNode(Node node) throws Exception {
        this.result.add("node");
        this.visitElement(node);
    }

    @Override
    public void visitProperty(Property property) throws Exception {
        String name = property.getName();
        boolean found = false;
        for (String k : Document.labelKinds) {
            if (!name.equals(k)) continue;
            this.result.add("label[@kind=\"" + name + "\"]");
            found = true;
            break;
        }
        if (!found) {
            this.result.add(name);
        }
        this.visitElement(property);
    }

    @Override
    public void visitQueries(QueryList qlist) throws Exception {
        this.result.add("queries");
        this.visitElement(qlist);
    }

    @Override
    public void visitQuery(Query query) throws Exception {
        this.result.add("query");
        this.visitElement(query);
    }

    @Override
    public void visitSettings(EngineSettings settings) throws Exception {
    }

    @Override
    public void visitResults(QueryResult result) throws Exception {
    }

    @Override
    public void visitExpect(QueryExpected expect) throws Exception {
    }

    @Override
    public void visitResourceList(List<QueryResource> resources) throws Exception {
    }

    @Override
    public void visitQueryValue(QueryValue value) throws Exception {
    }

    @Override
    public void visitConcretePlotConfigs(List<PlotConfiguration> plots) throws Exception {
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        this.result.add("nta");
        this.visitElement(document);
    }

    public int getChildNumber(Node node) {
        int i = 0;
        while (node != null) {
            node = node.getPrevious();
            ++i;
        }
        return i;
    }

    public int getLocationNumber(Node node) {
        int i = 0;
        while (node != null) {
            if (node instanceof Location) {
                ++i;
            }
            node = node.getPrevious();
        }
        return i;
    }

    public int getEdgeNumber(Node node) {
        int i = 0;
        while (node != null) {
            if (node instanceof Edge) {
                ++i;
            }
            node = node.getPrevious();
        }
        return i;
    }

    @Override
    public void visitTemplate(AbstractTemplate template) throws Exception {
        this.result.add("template[" + this.getChildNumber(template) + "]");
        this.visitElement(template);
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        this.result.add("location[" + this.getLocationNumber(location) + "]");
        this.visitElement(location);
    }

    @Override
    public void visitBranchPoint(BranchPoint branchPoint) throws Exception {
        this.result.add("branchpoint[" + this.getChildNumber(branchPoint) + "]");
        this.visitElement(branchPoint);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.result.add("transition[" + this.getEdgeNumber(edge) + "]");
        this.visitElement(edge);
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.result.add("nail[" + this.getChildNumber(nail) + "]");
        this.visitElement(nail);
    }

    @Override
    public void visitInstanceLine(InstanceLine instance) throws Exception {
        this.result.add("instance[" + this.getChildNumber(instance) + "]");
        this.visitElement(instance);
    }

    @Override
    public void visitPrechart(Prechart prechart) throws Exception {
        this.result.add("prechart[" + this.getChildNumber(prechart) + "]");
        this.visitElement(prechart);
    }

    @Override
    public void visitMessage(Message message) throws Exception {
        this.result.add("message[" + this.getChildNumber(message) + "]");
        this.visitElement(message);
    }

    @Override
    public void visitUpdate(Update update) throws Exception {
        this.result.add("update[" + this.getChildNumber(update) + "]");
        this.visitElement(update);
    }

    @Override
    public void visitCondition(Condition condition) throws Exception {
        this.result.add("condition[" + this.getChildNumber(condition) + "]");
        this.visitElement(condition);
    }

    @Override
    public void visitCut(Cut cut) throws Exception {
        this.result.add("cut[" + this.getChildNumber(cut) + "]");
        this.visitElement(cut);
    }
}

