/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.MarkSelectionCommand;
import com.uppaal.model.core2.Property;

public class RemoveTextCommand
extends MarkSelectionCommand {
    protected Object oldvalue = null;
    protected int oldlength = 0;
    protected String newvalue = null;

    public RemoveTextCommand(Property property, int position, int length, boolean allowCollapse) {
        super(property, position, length, allowCollapse);
    }

    @Override
    public void execute() {
        this.oldvalue = this.property.getValue();
        String value = (String)this.oldvalue;
        assert (value != null);
        this.oldlength = value.length();
        if (this.newvalue == null) {
            assert (this.position + this.length <= this.oldlength);
            this.newvalue = value.substring(0, this.position) + value.substring(this.position + this.length);
        }
        this.property.setValue(this.newvalue);
        super.execute();
    }

    @Override
    public boolean merge(Command next) {
        if (this.commands != null) {
            return super.merge(next);
        }
        if (!(next instanceof RemoveTextCommand) || this.getModifiedElement() != next.getModifiedElement()) {
            return super.merge(next);
        }
        RemoveTextCommand cmd = (RemoveTextCommand)next;
        assert (cmd.position + cmd.length <= this.oldlength - this.length);
        if (cmd.position + cmd.length == this.position) {
            this.length += cmd.length;
            this.position = cmd.position;
            this.newvalue = null;
            return true;
        }
        if (cmd.position == this.position) {
            this.length += cmd.length;
            this.newvalue = null;
            return true;
        }
        return super.merge(next);
    }

    @Override
    public void undo() {
        super.undo();
        this.property.setValue(this.oldvalue);
    }

    @Override
    public Element getModifiedElement() {
        return this.property;
    }
}

