/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTemplate;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.BranchPoint;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.lsc.LscTemplate;
import java.util.Map;

public class PrintVisitor
extends AbstractVisitor {
    protected int indentation = 0;

    protected void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            System.out.print("    ");
        }
    }

    protected void print(String s) {
        this.indent();
        System.out.println(s);
    }

    @Override
    public void visitElement(Element e) throws Exception {
        for (Map.Entry<String, Property> entry : e.getProperties().entrySet()) {
            this.print(entry.getKey() + ": " + entry.getValue().getValue());
            entry.getValue().accept(this);
        }
    }

    @Override
    public void visitTemplate(AbstractTemplate t) throws Exception {
        if (t instanceof LscTemplate) {
            this.print("LscTemplate:");
        } else {
            this.print("Template:");
        }
        ++this.indentation;
        super.visitTemplate(t);
        --this.indentation;
    }

    @Override
    public void visitLocation(Location l) throws Exception {
        this.print("Location:");
        ++this.indentation;
        super.visitLocation(l);
        --this.indentation;
    }

    @Override
    public void visitBranchPoint(BranchPoint b) throws Exception {
        this.print("BranchPoint:");
        ++this.indentation;
        super.visitBranchPoint(b);
        --this.indentation;
    }

    @Override
    public void visitEdge(Edge e) throws Exception {
        this.print("Edge " + e.getSource().getPropertyValue("name") + " -> " + e.getTarget().getPropertyValue("name"));
        ++this.indentation;
        super.visitEdge(e);
        --this.indentation;
    }

    @Override
    public void visitNail(Nail n) throws Exception {
        this.print("Via");
        ++this.indentation;
        super.visitNail(n);
        --this.indentation;
    }
}

