/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Visitor;
import java.util.Optional;

public class Node
extends Element {
    public Node previous;
    public Node next;
    public Node first;

    public Node(Element prototype) {
        super(prototype);
    }

    public Node getPrevious() {
        return this.previous;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getFirst() {
        return this.first;
    }

    public Node getLast() {
        Node node = this.first;
        if (node != null) {
            while (node.next != null) {
                node = node.next;
            }
        }
        return node;
    }

    @Override
    public void accept(Visitor visitor) throws Exception {
        visitor.visitNode(this);
    }

    public <T extends Node> Optional<T> getFirstInstance(Class<T> type) {
        Node child;
        for (child = this.getFirst(); child != null && !type.isInstance(child); child = child.getNext()) {
        }
        return child != null ? Optional.of((Node)type.cast(child)) : Optional.empty();
    }

    public Node insert(Node node, Node position) {
        node.parent = this;
        node.previous = position;
        if (position == null) {
            node.next = this.first;
            this.first = node;
        } else {
            node.next = position.next;
            position.next = node;
        }
        if (node.next != null) {
            node.next.previous = node;
        }
        node.fireInsertionEvent(this);
        return node;
    }

    public Node move(Node child, Node position) {
        assert (child.parent == this);
        assert (position == null || position.parent == this);
        if (this.first == child) {
            this.first = child.next;
        } else {
            child.previous.next = child.next;
        }
        if (child.next != null) {
            child.next.previous = child.previous;
        }
        child.previous = position;
        if (position == null) {
            child.next = this.first;
            this.first = child;
        } else {
            child.next = position.next;
            position.next = child;
        }
        if (child.next != null) {
            child.next.previous = child;
        }
        this.fireAfterMoveEvent(child);
        return this;
    }

    public void remove() {
        assert (this.parent != null);
        Node thisParent = (Node)this.parent;
        this.fireBeforeRemoveEvent(thisParent);
        if (thisParent.first == this) {
            thisParent.first = this.next;
        } else {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        this.parent = null;
        this.fireAfterRemoveEvent(thisParent);
    }

    void fireBeforeRemoveEvent(Node parent) {
        if (parent.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.beforeRemoval(parent, this);
                }
            } while ((element = element.prototype) != null);
        }
    }

    void fireAfterRemoveEvent(Node parent) {
        if (parent.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.afterRemoval(parent, this);
                }
            } while ((element = element.prototype) != null);
        }
    }

    void fireInsertionEvent(Node parent) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.afterInsertion(parent, this);
                }
            } while ((element = element.prototype) != null);
        }
    }

    void fireAfterMoveEvent(Node child) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : (EventListener[])element.listeners.getListeners(EventListener.class)) {
                    l.afterMove(this, child);
                }
            } while ((element = element.prototype) != null);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.previous = null;
        node.next = null;
        node.first = null;
        Node pos = null;
        for (Node child = this.first; child != null; child = child.getNext()) {
            pos = node.insert((Node)child.clone(), pos);
        }
        return node;
    }

    @Override
    public void setPrototype(Element prototype) {
        super.setPrototype(prototype);
        for (Node node = this.first; node != null; node = node.getNext()) {
            node.importInto(this);
        }
    }

    @Override
    public String getXPathTag() {
        String tag = (String)this.getPropertyValue("#xml.tag");
        if (tag == null) {
            return null;
        }
        if (tag.contains("[")) {
            return tag;
        }
        if (tag.endsWith("!")) {
            return tag.substring(0, tag.length() - 1);
        }
        int index = 1;
        Node older = this.previous;
        while (older != null) {
            if (older.getClass().equals(this.getClass())) {
                ++index;
            }
            older = older.previous;
        }
        return tag + "[" + index + "]";
    }
}

