/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Data2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class DataSet2D
implements Iterable<Data2D> {
    public static final Point2D.Double emptyMin = new Point2D.Double(0.0, 0.0);
    public static final Point2D.Double emptyMax = new Point2D.Double(0.0, 1.0);
    public String title;
    public String xlabel;
    public String ylabel;
    boolean logx = false;
    boolean logy = false;
    ArrayList<Data2D> data = new ArrayList();
    ArrayList<String> comments = new ArrayList();
    Data2D last = null;
    static Color[] predefinedColors = new Color[]{new Color(0, 0, 0), new Color(230, 25, 75), new Color(60, 180, 75), new Color(255, 225, 25), new Color(0, 130, 200), new Color(245, 130, 48), new Color(145, 30, 180), new Color(70, 240, 240), new Color(240, 50, 230), new Color(210, 245, 60), new Color(250, 190, 212), new Color(0, 128, 128), new Color(220, 190, 255), new Color(170, 110, 40), new Color(255, 250, 200), new Color(128, 0, 0), new Color(170, 255, 195), new Color(128, 128, 0), new Color(255, 215, 180), new Color(0, 0, 128), new Color(128, 128, 128), new Color(255, 255, 255)};

    public DataSet2D(String title, String xlabel, String ylabel) {
        this.title = title;
        this.xlabel = xlabel;
        this.ylabel = ylabel;
    }

    public void addData(String legend, String type, Color color) {
        this.last = new Data2D(legend, type, color);
        this.data.add(this.last);
    }

    public void addData(String legend, String type) {
        Color color = this.data.size() < predefinedColors.length ? predefinedColors[this.data.size()] : predefinedColors[0];
        this.last = new Data2D(legend, type, color);
        this.data.add(this.last);
    }

    public void setTitle(String newtitle) {
        this.title = newtitle;
    }

    public void setXLabel(String newx) {
        this.xlabel = newx;
    }

    public void setYLabel(String newy) {
        this.ylabel = newy;
    }

    public void setLogX(boolean logx) {
        this.logx = logx;
        for (Data2D d : this) {
            d.setLogX(logx);
        }
    }

    public void setLogY(boolean logy) {
        this.logy = logy;
        for (Data2D d : this) {
            d.setLogY(logy);
        }
    }

    public void addData2D(Data2D data2d) {
        data2d.setLogX(this.logx);
        data2d.setLogY(this.logy);
        this.data.add(data2d);
    }

    public void removeData2D(Data2D data2d) {
        this.data.remove(data2d);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public void addSample(Point2D.Double p) {
        this.last.addSample(p);
    }

    public void addSample(double x, double y) {
        this.addSample(new Point2D.Double(x, y));
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public ArrayList<String> getComments() {
        return this.comments;
    }

    public String getTitle() {
        return this.title;
    }

    public String getXLabel() {
        return this.xlabel;
    }

    public String getYLabel() {
        return this.ylabel;
    }

    public Point2D.Double getMinimum() {
        if (this.data.isEmpty()) {
            return new Point2D.Double(DataSet2D.emptyMin.x, DataSet2D.emptyMin.y);
        }
        Point2D.Double min = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (Data2D d : this) {
            Point2D.Double p = d.getMinimum();
            min.x = min.x < p.x ? min.x : p.x;
            min.y = min.y < p.y ? min.y : p.y;
        }
        return min;
    }

    public Point2D.Double getMaximum() {
        if (this.data.isEmpty()) {
            return new Point2D.Double(DataSet2D.emptyMax.x, DataSet2D.emptyMax.y);
        }
        Point2D.Double max = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (Data2D d : this) {
            Point2D.Double p = d.getMaximum();
            max.x = max.x > p.x ? max.x : p.x;
            max.y = max.y > p.y ? max.y : p.y;
        }
        return max;
    }

    public double getMaxXDifference() {
        if (this.data.isEmpty()) {
            return DataSet2D.emptyMax.x;
        }
        double max = DataSet2D.emptyMax.x;
        for (Data2D data2D : this) {
            double d = data2D.getXMinDifference();
            max = max > d ? max : d;
        }
        return max;
    }

    public Data2D getData(int index) {
        return this.data.get(index);
    }

    @Override
    public Iterator<Data2D> iterator() {
        return this.data.iterator();
    }

    public void removeAbove(double x) {
        for (Data2D set : this.data) {
            set.removeAbove(x);
        }
    }
}

