/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.viewmodel;

import com.google.gson.annotations.SerializedName;
import com.uppaal.engine.protocol.viewmodel.ConcreteTraceViewModel;
import com.uppaal.engine.protocol.viewmodel.ErrorMessage;
import com.uppaal.engine.protocol.viewmodel.ModelCheckStatus;
import com.uppaal.engine.protocol.viewmodel.PlotViewModel;
import com.uppaal.engine.protocol.viewmodel.SymbolicTraceNode;
import com.uppaal.engine.protocol.viewmodel.SymbolicTraceViewModel;
import com.uppaal.engine.protocol.viewmodel.TraceViewModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class QueryResultViewModel {
    @SerializedName(value="status")
    private transient ModelCheckStatus status;
    @SerializedName(value="error")
    private ErrorMessage error;
    @SerializedName(value="result")
    private String result = "";
    @SerializedName(value="message")
    private String message = "";
    @SerializedName(value="plots")
    private List<PlotViewModel> plots = Collections.emptyList();
    @SerializedName(value="cyclelen")
    private int cycleLength;
    @SerializedName(value="strategy_decl")
    private String strategy;
    private transient TraceViewModel trace;

    public ModelCheckStatus parseModelCheckStatus(String s) {
        switch (s) {
            case "T": {
                return ModelCheckStatus.TRUE;
            }
            case "F": {
                return ModelCheckStatus.FALSE;
            }
            case "M": {
                return ModelCheckStatus.MAYBE_TRUE;
            }
            case "N": {
                return ModelCheckStatus.MAYBE_FALSE;
            }
            case "E": {
                return ModelCheckStatus.ERROR;
            }
            case "I": {
                return ModelCheckStatus.INTERRUPTED;
            }
        }
        return ModelCheckStatus.__INVALID;
    }

    public void setTrace(TraceViewModel trace) {
        assert (this.trace == null);
        this.trace = trace;
    }

    public void setStatus(String status) {
        assert (this.status == null);
        this.status = this.parseModelCheckStatus(status);
    }

    public char getStatusRepresentation() {
        switch (this.status) {
            case TRUE: {
                return 'T';
            }
            case FALSE: {
                return 'F';
            }
            case MAYBE_TRUE: {
                return 'M';
            }
            case MAYBE_FALSE: {
                return 'N';
            }
            case ERROR: {
                return 'E';
            }
            case INTERRUPTED: {
                return 'I';
            }
            case __INVALID: {
                return '\u0000';
            }
        }
        throw new RuntimeException("Error: Invalid value in query result status field");
    }

    public ModelCheckStatus getStatus() {
        return this.status;
    }

    public void setError(ErrorMessage em) {
        this.error = em;
    }

    public ErrorMessage getError() {
        return this.error;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setPlots(List<PlotViewModel> plots) {
        this.plots = plots;
    }

    public List<PlotViewModel> getPlots() {
        return this.plots;
    }

    public void setCycleLength(int cycleLength) {
        this.cycleLength = cycleLength;
    }

    public int getCycleLength() {
        return this.cycleLength;
    }

    public TraceViewModel getTrace() {
        return this.trace;
    }

    public boolean hasSymbolicTrace() {
        return this.trace != null && this.trace instanceof SymbolicTraceViewModel && ((SymbolicTraceViewModel)this.trace).getTrace() != null;
    }

    public boolean hasConcreteTrace() {
        return this.trace != null && this.trace instanceof ConcreteTraceViewModel && ((ConcreteTraceViewModel)this.trace).transitions != null;
    }

    public Optional<List<SymbolicTraceNode>> getSymbolicTrace() {
        if (this.trace instanceof SymbolicTraceViewModel && ((SymbolicTraceViewModel)this.trace).getTrace() != null) {
            return Optional.of(((SymbolicTraceViewModel)this.trace).getTrace());
        }
        return Optional.empty();
    }

    public Optional<ConcreteTraceViewModel> getConcreteTrace() {
        if (this.trace instanceof ConcreteTraceViewModel) {
            return Optional.of((ConcreteTraceViewModel)this.trace);
        }
        return Optional.empty();
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Optional<String> getStrategy() {
        return Optional.ofNullable(this.strategy);
    }
}

