/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.viewmodel;

import com.uppaal.engine.protocol.viewmodel.ConcreteStateViewModel;
import com.uppaal.engine.protocol.viewmodel.EdgeFieldViewModel;
import com.uppaal.model.system.SystemEdgeSelect;
import java.util.ArrayList;
import java.util.List;

public class ConcreteSuccessorQuery {
    ConcreteStateViewModel state;
    double delay;
    List<EdgeFieldViewModel> edges;
    double interval;

    public ConcreteSuccessorQuery(ConcreteStateViewModel state, double delay, SystemEdgeSelect[] edges, double interval) {
        this.state = state;
        this.delay = delay;
        this.edges = ConcreteSuccessorQuery.toEdgeFieldViewModel(edges);
        this.interval = interval;
    }

    private static List<EdgeFieldViewModel> toEdgeFieldViewModel(SystemEdgeSelect[] edges) {
        ArrayList<EdgeFieldViewModel> viewModelList = new ArrayList<EdgeFieldViewModel>();
        for (SystemEdgeSelect edgeSelect : edges) {
            boolean exists = false;
            int procID = edgeSelect.getProcess().getIndex();
            for (EdgeFieldViewModel viewModel : viewModelList) {
                int viewModelProcID = viewModel.getEdgeParts().get(0).getProcessId();
                if (viewModelProcID != procID) continue;
                viewModel.addEdgePart(new EdgeFieldViewModel.EdgePart(procID, edgeSelect.getIndex(), edgeSelect.getSelectList()));
                exists = true;
                break;
            }
            if (exists) continue;
            viewModelList.add(new EdgeFieldViewModel(edgeSelect));
        }
        return viewModelList;
    }
}

