/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol.viewmodel;

import com.google.gson.annotations.SerializedName;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.Limit;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConcreteStateViewModel {
    @SerializedName(value="locs")
    public List<Integer> locationIndices;
    @SerializedName(value="vars")
    public List<Integer> variableValues;
    @SerializedName(value="fpvars")
    public List<Double> floatingVariableValues;
    @SerializedName(value="clocks")
    public List<Double> clocks;
    @SerializedName(value="lim")
    public Limit maxDelay;

    public ConcreteStateViewModel() {
    }

    public ConcreteStateViewModel(ConcreteState state) {
        assert (state != null);
        this.locationIndices = Arrays.stream(state.getLocations()).map(loc -> loc.getIndex()).collect(Collectors.toList());
        this.maxDelay = state.getInvariant();
        this.variableValues = Arrays.stream(state.getVars()).boxed().collect(Collectors.toList());
        this.floatingVariableValues = Arrays.stream(state.getFPVars()).boxed().collect(Collectors.toList());
        this.clocks = Arrays.stream(state.getClocks()).boxed().collect(Collectors.toList());
    }

    private boolean CompareLists(List<?> listOne, List<?> listTwo) {
        if (listOne.size() != listTwo.size()) {
            return false;
        }
        for (int i = 0; i < listOne.size(); ++i) {
            if (listOne.get(i).equals(listTwo.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != ConcreteStateViewModel.class) {
            return false;
        }
        ConcreteStateViewModel other = (ConcreteStateViewModel)obj;
        if (!this.CompareLists(this.locationIndices, other.locationIndices)) {
            return false;
        }
        if (!this.CompareLists(this.variableValues, other.variableValues)) {
            return false;
        }
        if (!this.CompareLists(this.floatingVariableValues, other.floatingVariableValues)) {
            return false;
        }
        if (!this.CompareLists(this.clocks, other.clocks)) {
            return false;
        }
        return this.maxDelay.equals(other.maxDelay);
    }
}

