/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.protocol.JsonParser;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;

public class Response {
    public String type;
    public JsonElement content;
    private final JsonParser parser;

    public Response(String type, JsonElement content, JsonParser parser) {
        this.type = type;
        this.content = content;
        this.parser = parser;
    }

    public <T> Optional<T> as(Class<T> type) {
        if (this.content.isJsonObject()) {
            JsonObject jsonObject = this.content.getAsJsonObject();
            for (Field field : type.getFields()) {
                String name;
                if (Modifier.isTransient(field.getModifiers())) continue;
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                String string = name = serializedName == null ? field.getName() : serializedName.value();
                if (jsonObject.has(name)) continue;
                return Optional.empty();
            }
        }
        return Optional.ofNullable(this.parser.parse(this.content, type));
    }

    public <T> T expect(Class<T> type) throws ProtocolException {
        return this.as(type).orElseThrow(this::unknownTypeException);
    }

    public <T> Optional<T> asGeneric(Type type) {
        return Optional.ofNullable(this.parser.parseGeneric(this.content, type));
    }

    public <T> T expectGeneric(Type type) throws ProtocolException {
        return this.asGeneric(type).orElseThrow(this::unknownTypeException);
    }

    private ProtocolException unknownTypeException() {
        return new ProtocolException("Unknown content, received: '" + this.content.toString() + "'");
    }
}

