/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol;

import com.google.gson.reflect.TypeToken;
import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.EngineCrashException;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.ModelProblemException;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.connection.InitialConnection;
import com.uppaal.engine.protocol.JsonMessageParser;
import com.uppaal.engine.protocol.JsonMessageWriter;
import com.uppaal.engine.protocol.ParseException;
import com.uppaal.engine.protocol.Response;
import com.uppaal.engine.protocol.TAModelInterpreter;
import com.uppaal.engine.protocol.viewmodel.ConcreteHorizonQuery;
import com.uppaal.engine.protocol.viewmodel.ConcreteStateViewModel;
import com.uppaal.engine.protocol.viewmodel.ConcreteSuccessorQuery;
import com.uppaal.engine.protocol.viewmodel.ConcreteSuccessorViewModel;
import com.uppaal.engine.protocol.viewmodel.CustomStateMCCommand;
import com.uppaal.engine.protocol.viewmodel.DataSetViewModel;
import com.uppaal.engine.protocol.viewmodel.ErrorMessage;
import com.uppaal.engine.protocol.viewmodel.LeaseRequestCommand;
import com.uppaal.engine.protocol.viewmodel.ModelCheckStatus;
import com.uppaal.engine.protocol.viewmodel.PlotViewModel;
import com.uppaal.engine.protocol.viewmodel.PointFieldViewModel;
import com.uppaal.engine.protocol.viewmodel.ProcessViewModel;
import com.uppaal.engine.protocol.viewmodel.ProgressInfoViewModel;
import com.uppaal.engine.protocol.viewmodel.QueryResultViewModel;
import com.uppaal.engine.protocol.viewmodel.RandomTransitionQuery;
import com.uppaal.engine.protocol.viewmodel.RandomTransitionViewModel;
import com.uppaal.engine.protocol.viewmodel.SuccessorListViewModel;
import com.uppaal.engine.protocol.viewmodel.SuccessorViewModel;
import com.uppaal.engine.protocol.viewmodel.SymbolicStateViewModel;
import com.uppaal.engine.protocol.viewmodel.SystemInfoViewModel;
import com.uppaal.engine.protocol.viewmodel.SystemUploadHandshake;
import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.core2.QueryValue;
import com.uppaal.model.io2.Problem;
import com.uppaal.model.io2.XMLWriter;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.GanttChart;
import com.uppaal.model.system.IdentifierTranslator;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.ConcreteTrace;
import com.uppaal.model.system.concrete.RandomTransition;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTrace;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JsonProtocol
implements Protocol {
    private final JsonMessageWriter writer;
    private final JsonMessageParser parser;
    private boolean canceling = false;
    public static final String closeCommand = "close";
    private final Pattern intervalPattern = Pattern.compile("\\[\\d+\\.?\\d*,\\d+\\.?\\d*\\]");

    private JsonProtocol(InputStreamReader in, BufferedWriter out) {
        this(new JsonMessageParser(in, EngineCrashException.class), new JsonMessageWriter(out));
    }

    public JsonProtocol(JsonMessageParser in, JsonMessageWriter out) {
        this.parser = in;
        this.writer = out;
    }

    public static JsonProtocol handshake(InitialConnection connection) throws IOException, EngineException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.in, StandardCharsets.UTF_8));
        String line = reader.readLine();
        if (line == null) {
            throw new EngineException("Server closed connection.");
        }
        if ("json".equals(line)) {
            return new JsonProtocol(new InputStreamReader(connection.in, StandardCharsets.UTF_8), connection.out);
        }
        throw new ProtocolException("Unknown protocol version: " + line);
    }

    @Override
    public void close() throws IOException {
        this.writer.writeEmptyCommand(closeCommand);
    }

    @Override
    public String getVersion() throws IOException, EngineException {
        this.writer.writeEmptyCommand("getVersion");
        return this.parser.parseResponse(String.class);
    }

    @Override
    public String getOptionsInfo() throws EngineException, IOException {
        this.writer.writeEmptyCommand("getOptionsInfo");
        return this.parser.parseResponse(String.class);
    }

    @Override
    public void setOptions(String options) throws EngineException, IOException {
        this.writer.writeCommand("setOptions", options);
        this.parser.parseValidatedResponse();
    }

    @Override
    public SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        this.writer.writeEmptyCommand("getInitialStateSymbolic");
        SymbolicStateViewModel state = this.parser.parseResponse(SymbolicStateViewModel.class);
        return new TAModelInterpreter(system).interpretSymbolicState(state);
    }

    @Override
    public ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        this.writer.writeEmptyCommand("concreteGetInitial");
        ConcreteStateViewModel state = this.parser.parseResponse(ConcreteStateViewModel.class);
        return new TAModelInterpreter(system).interpretConcreteState(state);
    }

    @Override
    public ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException, CannotEvaluateException {
        this.writer.writeCommand("getSuccessors", new SymbolicStateViewModel(state));
        SuccessorListViewModel successorListViewModel = this.parser.parseResponse(SuccessorListViewModel.class);
        List<SuccessorViewModel> successors = successorListViewModel.getSuccessors();
        TAModelInterpreter interpreter = new TAModelInterpreter(system);
        return successors.stream().map(succ -> new SymbolicTransition(interpreter.interpretSymbolicState(succ.getSource()), interpreter.interpretEdgeSelectList(succ.getTransition()), interpreter.interpretSymbolicState(succ.getDest()))).collect(Collectors.toCollection(ArrayList::new));
    }

    private void uploadXMLSystem(Document document) throws EngineException, IOException {
        ByteArrayOutputStream sstream = new ByteArrayOutputStream();
        try {
            document.accept(new XMLWriter(sstream));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EngineException(e.toString());
        }
        this.writer.writeCommand("newXMLSystem3", sstream.toString());
    }

    @Override
    public UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        this.uploadXMLSystem(document);
        try {
            SystemUploadHandshake handshake = this.parser.parseWithManyErrors(SystemUploadHandshake.class);
            handshake.getWarnings().forEach(warning -> problems.add(new Problem("warning", (ErrorMessage)warning)));
            return this.produceSystem(handshake, document);
        }
        catch (ModelProblemException e) {
            e.getErrors().forEach(error -> problems.add(new Problem("error", (ErrorMessage)error)));
            e.getWarnings().forEach(warning -> problems.add(new Problem("warning", (ErrorMessage)warning)));
            return null;
        }
    }

    private UppaalSystem produceSystem(SystemUploadHandshake response, Document document) {
        UppaalSystem system = new UppaalSystem(document);
        system.setVariables((ArrayList)response.getVariableNames());
        system.setSupportedMethods(response.getSupportedMethods());
        system.setClocks((ArrayList)response.getClockNames());
        for (ProcessViewModel process : response.getProcesses()) {
            IdentifierTranslator translator = new IdentifierTranslator(process.getParameterReferences());
            system.addProcess(process.getProcName(), process.getTemplateName(), translator);
        }
        GanttChart gc = system.getGanttChart();
        if (gc == null) {
            gc = new GanttChart();
        } else {
            gc.clearChart();
        }
        for (int i = 0; i < response.getGanttRows().size(); ++i) {
            gc.addRow(response.getGanttRows().get(i));
        }
        system.setGanttChart(gc);
        return system;
    }

    @Override
    public UppaalSystem upload(Document document) throws EngineException, IOException {
        this.uploadXMLSystem(document);
        SystemUploadHandshake handshake = this.parser.parseResponse(SystemUploadHandshake.class);
        return this.produceSystem(handshake, document);
    }

    @Override
    public QueryResult query(UppaalSystem system, Query query, QueryFeedback feedback) throws EngineException, IOException {
        SystemInfoViewModel info = this.getSystemInfo();
        if (info != null) {
            feedback.setProgressAvail(true);
            feedback.setSystemInfo(info.virtTotal, info.physTotal, info.swapTotal);
        }
        this.writer.writeCommand("modelCheck", query.getShortFormula());
        this.writer.flush();
        this.canceling = false;
        return this.processQueryResult(system, feedback);
    }

    private QueryResult processQueryResult(UppaalSystem system, QueryFeedback feedback) throws IOException, ProtocolException {
        this.canceling = false;
        block10: while (true) {
            Response response = this.parser.parseRawResponse();
            switch (response.type) {
                case "prog": {
                    feedback.setProgress(response.expect(ProgressInfoViewModel.class));
                    this.writer.writeEmptyCommand(this.canceling ? "interrupt" : "continue");
                    continue block10;
                }
                case "ok": {
                    return this.processSymQueryResult(response.expect(QueryResultViewModel.class), system, feedback);
                }
                case "error": {
                    return new QueryResult(response.expect(ErrorMessage.class));
                }
            }
            break;
        }
        this.writer.flush();
        throw new RuntimeException();
    }

    public SystemInfoViewModel getSystemInfo() throws IOException, ProtocolException {
        this.writer.writeEmptyCommand("getSystemInfo");
        this.writer.flush();
        return this.parser.parseResponse(SystemInfoViewModel.class);
    }

    @Override
    public QueryResult query(UppaalSystem system, SymbolicState state, Query query, QueryFeedback feedback) throws EngineException, IOException {
        SystemInfoViewModel info = this.getSystemInfo();
        if (info != null) {
            feedback.setProgressAvail(true);
            feedback.setSystemInfo(info.virtTotal, info.physTotal, info.swapTotal);
        }
        this.writer.writeCommand("modelCheckState", new CustomStateMCCommand(state, query.getShortFormula()));
        this.writer.flush();
        this.canceling = false;
        return this.processQueryResult(system, feedback);
    }

    private QueryResult processSymQueryResult(QueryResultViewModel model, UppaalSystem system, QueryFeedback feedback) {
        TAModelInterpreter interpreter = new TAModelInterpreter(system);
        QueryResult result = new QueryResult(model);
        if (model.getStatus() == ModelCheckStatus.ERROR) {
            result.set(this.exceptionFromErrorMessage(model.getError()));
        }
        if (model.hasSymbolicTrace()) {
            SymbolicTrace trace = interpreter.interpretSymbolicTrace(model.getSymbolicTrace().get());
            trace.cycle = model.getCycleLength();
            feedback.setLength(trace.size());
            feedback.setTrace(model.getStatusRepresentation(), model.getMessage(), trace, result);
        } else if (model.hasConcreteTrace()) {
            ConcreteTrace trace = interpreter.interpretConcreteTrace(model.getConcreteTrace().get());
            feedback.setLength(trace.size());
            feedback.setTrace(model.getStatusRepresentation(), model.getMessage(), trace, result);
        } else if (model.getError() == null) {
            feedback.setFeedback(model.getMessage());
        }
        this.interpretValue(model.getResult(), result);
        result.setMessage(model.getResult());
        this.interpretPlots(model.getPlots(), result);
        return result;
    }

    private void interpretValue(String resultStr, QueryResult result) {
        if (resultStr.isEmpty()) {
            result.getValue().setKind(QueryValue.Kind.Quality);
        } else if (resultStr.startsWith("\u2264") || resultStr.startsWith("\u2265") || this.intervalPattern.matcher(resultStr).find()) {
            result.getValue().setKind(QueryValue.Kind.Interval);
            result.getValue().setValue(resultStr);
        } else {
            result.getValue().setKind(QueryValue.Kind.Quantity);
            result.getValue().setValue(resultStr);
        }
    }

    private CannotEvaluateException exceptionFromErrorMessage(ErrorMessage message) {
        return new CannotEvaluateException(message.begln, message.endln, message.ctx, message.msg, message.path, message.begcol, message.endcol);
    }

    private void interpretPlots(List<PlotViewModel> plots, QueryResult result) {
        for (PlotViewModel plot : plots) {
            DataSet2D dataset = new DataSet2D(plot.getTitle(), plot.getXlabel(), plot.getYlabel());
            result.addPlot(dataset);
            for (DataSetViewModel protocolData : plot.getDataSeries()) {
                dataset.addData(protocolData.getTitle(), protocolData.getType(), Color.decode(protocolData.getColor()));
                for (PointFieldViewModel point : protocolData.getPoints()) {
                    dataset.addSample(point.getX(), point.getY());
                }
            }
            for (String comment : plot.getComments().split("\\n")) {
                dataset.addComment(comment);
            }
        }
    }

    @Override
    public ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, double delay, double interval) throws EngineException, IOException, CannotEvaluateException {
        this.writer.writeCommand("concreteGetSuccessor", new ConcreteSuccessorQuery(new ConcreteStateViewModel(state), delay, edges, interval));
        ConcreteSuccessorViewModel successor = this.parser.parseResponse(ConcreteSuccessorViewModel.class);
        try {
            return new TAModelInterpreter(system).interpretConcreteSuccessor(successor);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("GanttChart not clonable");
        }
    }

    @Override
    public RandomTransition getRandomTransition(UppaalSystem system, ConcreteState state, RandomTransitionQuery.RandomSemantics randomSemantics, double horizon) throws IOException, CannotEvaluateException, ProtocolException, ParseException {
        this.writer.writeCommand("concreteGetRandom", new RandomTransitionQuery(new ConcreteStateViewModel(state), randomSemantics, horizon));
        RandomTransitionViewModel transition = this.parser.parseResponse(RandomTransitionViewModel.class);
        return new TAModelInterpreter(system).interpretRandomTransition(transition);
    }

    @Override
    public DataSet2D getConcreteTrajectory(UppaalSystem system, ConcreteState state, double horizon) throws ProtocolException, IOException, ParseException {
        this.writer.writeCommand("concreteGetHorizon", new ConcreteHorizonQuery(new ConcreteStateViewModel(state), horizon));
        ArrayList datasets = (ArrayList)this.parser.parseGeneric(new TypeToken<ArrayList<DataSetViewModel>>(){}.getType());
        DataSet2D test = new DataSet2D("Horizons", "#time", "Value");
        for (DataSetViewModel dataset : datasets) {
            test.addData(dataset.getTitle(), dataset.getType());
            for (PointFieldViewModel point : dataset.getPoints()) {
                test.addSample(point.getX(), point.getY());
            }
        }
        return test;
    }

    @Override
    public ArrayList<String> getStrategies(boolean zone_stable) {
        try {
            if (zone_stable) {
                this.writer.writeEmptyCommand("getZoneStableStrategies");
            } else {
                this.writer.writeEmptyCommand("getStrategies");
            }
            return (ArrayList)this.parser.parseGeneric(new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (ProtocolException | IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setStrategy(String strategy, boolean zone_stable) {
        try {
            if (zone_stable) {
                this.writer.writeCommand("setZoneStrategy", strategy);
            } else {
                this.writer.writeCommand("setStrategy", strategy);
            }
            try {
                this.parser.parseValidatedResponse();
            }
            catch (ProtocolException e) {
                throw new RuntimeException("No such strategy", e);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException in setStrategy", ex);
        }
    }

    @Override
    public String getLicensee() throws IOException {
        this.writer.writeEmptyCommand("getLicensee");
        try {
            return this.parser.parseResponse(String.class);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getLeaseRequest(String license_key, String duration) throws IOException, ProtocolException {
        this.writer.writeCommand("leaseRequest", new LeaseRequestCommand(license_key, duration));
        return this.parser.parseResponse(String.class);
    }

    @Override
    public String installLease(String lease) throws IOException, ProtocolException, ParseException {
        this.writer.writeCommand("leaseInstall", lease);
        return this.parser.parseResponse(String.class);
    }

    @Override
    public String getStrategy(String strategy) throws IOException, ProtocolException {
        this.writer.writeCommand("getStrategyJson", strategy);
        return this.parser.parseResponse(String.class);
    }

    @Override
    public void cancel() {
        this.canceling = true;
    }

    @Override
    public LscProcess uploadLsc(Document document, ArrayList<Problem> problems) {
        return null;
    }
}

