/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.protocol;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.ModelProblemException;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.protocol.JsonParser;
import com.uppaal.engine.protocol.LicenseMissingException;
import com.uppaal.engine.protocol.Response;
import com.uppaal.engine.protocol.viewmodel.ErrorMessage;
import com.uppaal.engine.protocol.viewmodel.ModelProblemsViewModel;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Optional;

public class JsonMessageParser {
    private final JsonParser parser;

    public JsonMessageParser(byte[] arr, Class<? extends RuntimeException> engineSpecificException) {
        this.parser = new JsonParser(arr, engineSpecificException);
    }

    public JsonMessageParser(InputStreamReader in, Class<? extends RuntimeException> engineSpecificException) {
        this.parser = new JsonParser(in, engineSpecificException);
    }

    public <T> T parseGeneric(Type type) throws ProtocolException {
        Response response = this.parseValidatedResponse();
        return response.expectGeneric(type);
    }

    public <T> T parseResponse(Class<T> type) throws ProtocolException {
        Response response = this.parseValidatedResponse();
        return response.expect(type);
    }

    public Response parseRawResponse() {
        return this.parser.parse(Response.class);
    }

    public Response parseValidatedResponse() throws ProtocolException {
        Response response = this.parseRawResponse();
        this.validateResponse(response);
        return response;
    }

    private void validateResponse(Response response) throws ProtocolException {
        switch (response.type) {
            case "ok": {
                return;
            }
            case "error": {
                throw new CannotEvaluateException(response.expect(ErrorMessage.class));
            }
            case "err": {
                this.handleException(response);
            }
        }
        if (!response.type.isEmpty()) {
            throw new ProtocolException("Received unknown response '" + response.type + "'");
        }
        throw new RuntimeException("Engine failed to respond to request");
    }

    public <T> T parseWithManyErrors(Class<T> type) throws ProtocolException, ModelProblemException {
        Response response = this.parseRawResponse();
        this.checkForMultipleProblems(response);
        this.validateResponse(response);
        return response.expect(type);
    }

    private void checkForMultipleProblems(Response response) throws ProtocolException, ModelProblemException {
        if (!"error".equals(response.type)) {
            return;
        }
        Optional<ModelProblemsViewModel> problems = response.as(ModelProblemsViewModel.class);
        if (problems.isPresent()) {
            if (problems.get().isEmpty()) {
                throw new ProtocolException("Model failed to compile but no errors were given");
            }
            throw new ModelProblemException(problems.get());
        }
    }

    private void handleException(Response response) throws ProtocolException {
        String content = response.expect(String.class);
        if (content.equals("License key is not installed")) {
            throw new LicenseMissingException();
        }
        throw new ProtocolException("Error: " + content);
    }
}

