/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.connection;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.connection.Connection;
import com.uppaal.engine.connection.InitialConnection;
import com.uppaal.engine.connection.ServerUnavailableException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class RemoteConnection
extends Connection {
    private final int serverPort;
    private final String serverHost;
    private Socket socket;

    public RemoteConnection(String name, String serverHost, int serverPort) {
        super(name);
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public InitialConnection connect() throws EngineException {
        try {
            this.socket = new Socket(this.serverHost, this.serverPort);
            OutputStream out = this.socket.getOutputStream();
            InputStream in = this.socket.getInputStream();
            BufferedWriter bufferedOut = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            return new InitialConnection(in, bufferedOut);
        }
        catch (ConnectException e) {
            throw new ServerUnavailableException("Could not connect to " + this.serverHost + ":" + this.serverPort + ". " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServerUnavailableException(e.getMessage());
        }
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public void kill() {
        this.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null;
    }

    @Override
    public Connection clone() {
        return new RemoteConnection(this.getName(), this.serverHost, this.serverPort);
    }

    public String toString() {
        ResourceBundle LOCALE = ResourceBundle.getBundle("locale.SystemInspector");
        return MessageFormat.format(LOCALE.getString("si_connectRemote"), this.serverHost, this.serverPort);
    }
}

