/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Objects;

public class CircularByteOutputStream
extends ByteArrayOutputStream {
    private boolean firstIteration = true;

    public CircularByteOutputStream(int size) {
        super(size);
    }

    @Override
    public void reset() {
        super.reset();
        this.firstIteration = true;
    }

    @Override
    public int size() {
        return this.firstIteration ? this.count : this.buf.length;
    }

    @Override
    public void write(int b) {
        super.write(b);
        if (this.count >= this.buf.length) {
            this.firstIteration = false;
            this.count = 0;
        }
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len > this.buf.length) {
            int redundantBytes = len - this.buf.length;
            off += redundantBytes;
            len = this.buf.length;
        }
        int remaining = this.buf.length - this.count;
        while (len >= remaining) {
            super.write(b, off, remaining);
            this.count = 0;
            this.firstIteration = false;
            len -= remaining;
            off += remaining;
        }
        super.write(b, off, len);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.firstIteration) {
            out.write(this.buf, 0, this.count);
        } else {
            out.write(this.buf, this.count, this.buf.length - this.count);
            out.write(this.buf, 0, this.count);
        }
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.size());
        try {
            this.writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    @Override
    public String toString() {
        return this.toString(Charset.defaultCharset());
    }

    @Override
    public String toString(String charset) throws UnsupportedEncodingException {
        return this.toString(Charset.forName(charset));
    }

    @Override
    public String toString(Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.size());
        try {
            this.writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }
}

