/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine.connection;

import com.uppaal.engine.BinaryResolution;
import com.uppaal.engine.ExecutableValidator;
import com.uppaal.engine.connection.Connection;
import com.uppaal.engine.connection.LocalConnection;
import com.uppaal.model.OSUtils;
import java.io.File;

public class BundledConnection
extends LocalConnection {
    public static final String BUNDLED = "Bundled";
    private static File bundledEngine = null;

    private static String getEngineName() {
        switch (OSUtils.getOS()) {
            case LINUX: 
            case SUNOS: 
            case MACOS: {
                return "server";
            }
            case WIN: {
                return "server.exe";
            }
        }
        throw new RuntimeException("Unknown operating system");
    }

    public static void setBundledEngine(File bundledEngine) {
        BundledConnection.bundledEngine = bundledEngine;
    }

    public BundledConnection(BinaryResolution binaryResolution) {
        super(BUNDLED, BundledConnection.findExecutable(binaryResolution));
    }

    private static File findExecutable(BinaryResolution binaryResolution) {
        ExecutableValidator validator = new ExecutableValidator("close");
        return binaryResolution.search(BundledConnection.getEngineName(), validator::isValid).orElseGet(() -> binaryResolution.defaultLocation(BundledConnection.getEngineName()));
    }

    private BundledConnection(String name, File serverBinary) {
        super(name, serverBinary);
    }

    @Override
    public Connection clone() {
        return new BundledConnection(this.getName(), this.getServerBinary());
    }
}

