/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CancellableToken;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.SwingUtilities;

public class SwingFuture<T>
implements Future<T>,
CompletionStage<T> {
    private final CompletableFuture<T> base;
    private CancellableToken cancellableToken;

    public SwingFuture(CompletableFuture<T> base) {
        this.base = base;
    }

    public SwingFuture() {
        this.base = new CompletableFuture();
    }

    public SwingFuture<T> setCancelToken(CancellableToken cancellableToken) {
        if (cancellableToken == null) {
            throw new IllegalArgumentException("Does not accept null argument");
        }
        this.cancellableToken = cancellableToken;
        return this;
    }

    public static <U> SwingFuture<U> completedFuture(U value) {
        return new SwingFuture<U>(CompletableFuture.completedFuture(value));
    }

    public static <U> SwingFuture<U> failedFuture(Throwable exception) {
        return new SwingFuture(CompletableFuture.failedFuture(exception));
    }

    public static SwingFuture<Void> allOf(SwingFuture<?> ... futures) {
        return new SwingFuture<Void>(CompletableFuture.allOf(SwingFuture.getArray(futures)));
    }

    public static SwingFuture<Object> anyOf(SwingFuture<?> ... futures) {
        return new SwingFuture<Object>(CompletableFuture.anyOf(SwingFuture.getArray(futures)));
    }

    private static CompletableFuture[] getArray(SwingFuture[] futures) {
        return (CompletableFuture[])Arrays.stream(futures).map(f -> f.base).toArray(CompletableFuture[]::new);
    }

    public SwingFuture<Void> swingRun(Runnable runnable) {
        SwingFuture<Void> future = new SwingFuture<Void>();
        this.thenRun(() -> this.swingInvokeLater(() -> {
            runnable.run();
            future.complete(null);
        }));
        return future;
    }

    public SwingFuture<Void> swingAccept(Consumer<T> consumer) {
        SwingFuture<Void> future = new SwingFuture<Void>();
        this.thenAccept((T t) -> this.swingInvokeLater(() -> {
            consumer.accept(t);
            future.complete(null);
        }));
        return future;
    }

    public <U> SwingFuture<U> swingApply(Function<T, U> function) {
        SwingFuture future = new SwingFuture();
        this.thenAccept((T t) -> this.swingInvokeLater(() -> {
            Object u = function.apply(t);
            future.complete(u);
        }));
        return future;
    }

    public SwingFuture<T> swingExceptionally(Consumer<Throwable> consumer) {
        this.base.exceptionally((T ex) -> {
            this.swingInvokeLater(() -> consumer.accept((Throwable)ex));
            return null;
        });
        return this;
    }

    private void swingInvokeLater(Runnable runnable) {
        if (this.cancellableToken != null) {
            this.cancellableToken.invokeLater(runnable);
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.base.cancel(mayInterruptIfRunning);
    }

    public boolean complete(T value) {
        return this.base.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.base.completeExceptionally(ex);
    }

    public SwingFuture<T> copy() {
        return new SwingFuture<T>(this.base.copy());
    }

    public T join() {
        return this.base.join();
    }

    private <U> SwingFuture<U> wrap(CompletableFuture<U> future) {
        SwingFuture<U> newFuture = new SwingFuture<U>(future);
        newFuture.cancellableToken = this.cancellableToken;
        return newFuture;
    }

    public SwingFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.base.thenAccept((Consumer)action));
    }

    public SwingFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.base.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public SwingFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.base.acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    public SwingFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public SwingFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.base.thenAcceptAsync((Consumer)action));
    }

    public SwingFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.thenAcceptAsync((Consumer)action, executor));
    }

    public <U> SwingFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.wrap((CompletableFuture<U>)this.base.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> SwingFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.wrap((CompletableFuture<U>)this.base.thenAcceptBothAsync(other, (BiConsumer)action));
    }

    public <U> SwingFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    @Override
    public <U> SwingFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.applyToEither((CompletionStage)other, fn));
    }

    @Override
    public <U> SwingFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.applyToEitherAsync((CompletionStage)other, fn));
    }

    @Override
    public <U> SwingFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    @Override
    public <U> SwingFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenApply(fn));
    }

    @Override
    public <U> SwingFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenApplyAsync(fn));
    }

    @Override
    public <U> SwingFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.thenApplyAsync(fn, executor));
    }

    @Override
    public SwingFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.wrap((CompletableFuture)this.base.whenCompleteAsync(action));
    }

    @Override
    public SwingFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.whenCompleteAsync(action, executor));
    }

    @Override
    public <U> SwingFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenComposeAsync(fn));
    }

    @Override
    public <U> SwingFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.thenComposeAsync(fn, executor));
    }

    @Override
    public <U, V> SwingFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenCombineAsync(other, fn));
    }

    @Override
    public <U, V> SwingFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.thenCombineAsync(other, fn, executor));
    }

    public SwingFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.base.runAfterBoth((CompletionStage)other, action));
    }

    public SwingFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.base.runAfterBothAsync((CompletionStage)other, action));
    }

    public SwingFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    public SwingFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.base.runAfterEither((CompletionStage)other, action));
    }

    public SwingFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.base.runAfterEitherAsync((CompletionStage)other, action));
    }

    public SwingFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    public SwingFuture<Void> thenRun(Runnable action) {
        return this.wrap((CompletableFuture)this.base.thenRun(action));
    }

    public SwingFuture<Void> thenRunAsync(Runnable action) {
        return this.wrap((CompletableFuture)this.base.thenRunAsync(action));
    }

    public SwingFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.base.thenRunAsync(action, executor));
    }

    public SwingFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return this.wrap(this.base.completeOnTimeout(value, timeout, unit));
    }

    @Override
    public SwingFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.wrap((CompletableFuture)this.base.exceptionally(fn));
    }

    @Override
    public <U, V> SwingFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenCombine(other, fn));
    }

    @Override
    public <U> SwingFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.wrap((CompletableFuture<U>)this.base.thenCompose(fn));
    }

    @Override
    public SwingFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.wrap((CompletableFuture)this.base.whenComplete(action));
    }

    @Override
    public <U> SwingFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.handle(fn));
    }

    @Override
    public <U> SwingFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.base.handleAsync(fn));
    }

    @Override
    public <U> SwingFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.base.handleAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.base.toCompletableFuture();
    }

    public SwingFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return this.wrap(this.base.orTimeout(timeout, unit));
    }

    @Override
    public boolean isCancelled() {
        return this.base.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.base.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.base.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.base.get(timeout, unit);
    }
}

