/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.CannotEvaluateException;
import com.uppaal.engine.CrashSaver;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.Protocol;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.engine.connection.Connection;
import com.uppaal.engine.connection.RemoteConnection;
import com.uppaal.engine.connection.ServerUnavailableException;
import com.uppaal.engine.protocol.JsonProtocol;
import com.uppaal.engine.protocol.viewmodel.RandomTransitionQuery;
import com.uppaal.model.core2.DataSet2D;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Query;
import com.uppaal.model.core2.QueryResult;
import com.uppaal.model.io2.Problem;
import com.uppaal.model.lscsystem.LscProcess;
import com.uppaal.model.system.SystemEdgeSelect;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.model.system.concrete.ConcreteState;
import com.uppaal.model.system.concrete.ConcreteSuccessor;
import com.uppaal.model.system.concrete.RandomTransition;
import com.uppaal.model.system.symbolic.SymbolicState;
import com.uppaal.model.system.symbolic.SymbolicTransition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class EngineStub {
    private Protocol protocol;
    private final LinkedHashMap<String, Connection> connections = new LinkedHashMap();
    Connection connection;
    private String licensee;

    public String getErrorStream() {
        return this.connection.getErrorStream();
    }

    public int getServerPort() {
        if (this.connection instanceof RemoteConnection) {
            return ((RemoteConnection)this.connection).getServerPort();
        }
        return -1;
    }

    public synchronized void setConnectionMode(String mode) {
        this.connection = this.connections.get(mode);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HashMap<String, Connection> getConnections() {
        return this.connections;
    }

    public void resetConnections(List<Connection> connections) {
        this.connections.clear();
        String oldConnectionName = this.connection != null ? this.connection.getName() : "";
        this.connection = null;
        for (Connection conn : connections) {
            this.addConnection(conn);
            if (!conn.getName().equals(oldConnectionName)) continue;
            this.connection = conn;
        }
        if (this.connection == null) {
            this.connection = connections.get(0);
        }
    }

    public void addConnection(Connection connection) {
        this.connections.put(connection.getName(), connection);
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void saveTrace() {
        if (this.connection.hasTrace()) {
            CrashSaver.SaveCrash("enginecrash", this.connection.dumpTrace());
        }
    }

    public synchronized void connect() throws EngineException, IOException {
        if (this.connection == null && !this.connections.isEmpty()) {
            this.connection = this.connections.get("Bundled");
            if (this.connection == null) {
                this.connection = this.connections.entrySet().iterator().next().getValue();
            }
        }
        if (this.connection == null) {
            throw new ServerUnavailableException("No connection selected");
        }
        this.protocol = JsonProtocol.handshake(this.connection.connectWithMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object lock;
        if (!this.isConnected()) {
            return;
        }
        Object object = lock = new Object();
        synchronized (object) {
            block6: {
                Thread t = new Thread("ProtocolWaiter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (EngineStub.this.protocol != null) {
                                EngineStub.this.protocol.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                };
                t.start();
                try {
                    lock.wait(2000L);
                    this.kill();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (this.connection == null) break block6;
                    this.connection.disconnect();
                }
            }
        }
        this.kill();
    }

    public void kill() {
        this.licensee = null;
        for (Connection conn : this.connections.values()) {
            conn.kill();
        }
    }

    public synchronized String getVersion() throws IOException, EngineException {
        try {
            return this.protocol.getVersion();
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    private void checkForEngineException(IOException e) throws EngineException {
        String err = this.getErrorStream();
        if (err != null && err.length() > 0) {
            this.saveTrace();
            throw new EngineException(err, e);
        }
    }

    public synchronized String getOptionsInfo() throws EngineException, IOException {
        try {
            return this.protocol.getOptionsInfo();
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized void setOptions(String options) throws EngineException, IOException {
        try {
            this.protocol.setOptions(options);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized SymbolicState getSymbolicInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getSymbolicInitial(system);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized ConcreteState getConcreteInitial(UppaalSystem system) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getConcreteInitial(system);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized ConcreteSuccessor getConcreteSuccessor(UppaalSystem system, ConcreteState state, SystemEdgeSelect[] edges, double delay, double interval) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getConcreteSuccessor(system, state, edges, delay, interval);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized RandomTransition getRandomTransition(UppaalSystem system, ConcreteState state, RandomTransitionQuery.RandomSemantics randomSemantics, double horizon) throws Exception {
        return this.protocol.getRandomTransition(system, state, randomSemantics, horizon);
    }

    public synchronized DataSet2D getConcreteTrajectory(UppaalSystem system, ConcreteState state, double horizon) throws EngineException, IOException {
        return this.protocol.getConcreteTrajectory(system, state, horizon);
    }

    public synchronized ArrayList<SymbolicTransition> getTransitions(UppaalSystem system, SymbolicState state) throws EngineException, IOException, CannotEvaluateException {
        try {
            return this.protocol.getTransitions(system, state);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized UppaalSystem upload(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        if (this.protocol == null) {
            this.saveTrace();
            throw new IOException("Could not connect to server");
        }
        try {
            return this.protocol.upload(document, problems);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized LscProcess uploadLsc(Document document, ArrayList<Problem> problems) throws EngineException, IOException {
        try {
            return this.protocol.uploadLsc(document, problems);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized UppaalSystem upload(Document document) throws EngineException, IOException {
        try {
            return this.protocol.upload(document);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized QueryResult query(UppaalSystem system, Query query, QueryFeedback f) throws EngineException, IOException {
        try {
            return this.protocol.query(system, query, f);
        }
        catch (EngineException e) {
            this.saveTrace();
            throw e;
        }
        catch (IOException e) {
            String err = this.getErrorStream();
            if (err != null && err.length() > 0) {
                this.saveTrace();
                throw new EngineException(err, e);
            }
            this.kill();
            throw e;
        }
    }

    public synchronized QueryResult query(UppaalSystem system, SymbolicState state, Query query, QueryFeedback f) throws EngineException, IOException, CannotEvaluateException {
        return this.protocol.query(system, state, query, f);
    }

    public synchronized String getLicensee() throws IOException, EngineException {
        try {
            if (this.licensee == null || this.licensee.isEmpty()) {
                this.licensee = this.protocol.getLicensee();
            }
            return this.licensee;
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized String getLeaseRequest(String license_key, String duration) throws IOException, EngineException {
        try {
            this.licensee = null;
            return this.protocol.getLeaseRequest(license_key, duration);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    public synchronized void leaseInstall(String lease) throws IOException, EngineException {
        try {
            this.licensee = null;
            this.protocol.installLease(lease);
        }
        catch (IOException e) {
            this.checkForEngineException(e);
            throw e;
        }
    }

    void cancel() {
        this.protocol.cancel();
    }

    ArrayList<String> getStrategies(boolean zone_stable) {
        return this.protocol.getStrategies(zone_stable);
    }

    void setStrategy(String name, boolean zone_stable) {
        this.protocol.setStrategy(name, zone_stable);
    }

    public String getStrategy(String strategy) throws ProtocolException, IOException {
        return this.protocol.getStrategy(strategy);
    }
}

